/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cat;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch.cat.CatRequestBase;
import co.elastic.clients.elasticsearch.cat.CountResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class CountRequest
extends CatRequestBase {
    private final List<String> h;
    private final List<String> index;
    private final List<String> s;
    public static final Endpoint<CountRequest, CountResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CountRequest, CountResponse>("es/cat.count", request -> "GET", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_cat");
            buf.append("/count");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _index = true;
        boolean propsSet = false;
        if (ApiTypeHelper.isDefined(request.index())) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("index", request.index.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("format", "json");
        if (ApiTypeHelper.isDefined(request.s)) {
            params.put("s", request.s.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (ApiTypeHelper.isDefined(request.h)) {
            params.put("h", request.h.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CountResponse._DESERIALIZER);

    private CountRequest(Builder builder) {
        this.h = ApiTypeHelper.unmodifiable(builder.h);
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.s = ApiTypeHelper.unmodifiable(builder.s);
    }

    public static CountRequest of(Function<Builder, ObjectBuilder<CountRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> h() {
        return this.h;
    }

    public final List<String> index() {
        return this.index;
    }

    public final List<String> s() {
        return this.s;
    }

    public static class Builder
    extends CatRequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CountRequest> {
        @Nullable
        private List<String> h;
        @Nullable
        private List<String> index;
        @Nullable
        private List<String> s;

        public final Builder h(List<String> list) {
            this.h = Builder._listAddAll(this.h, list);
            return this;
        }

        public final Builder h(String value, String ... values) {
            this.h = Builder._listAdd(this.h, value, values);
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder s(List<String> list) {
            this.s = Builder._listAddAll(this.s, list);
            return this;
        }

        public final Builder s(String value, String ... values) {
            this.s = Builder._listAdd(this.s, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CountRequest build() {
            this._checkSingleUse();
            return new CountRequest(this);
        }
    }
}

