/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.NamedDeserializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class KnnSearchResponse<TDocument>
implements JsonpSerializable {
    private final long took;
    private final boolean timedOut;
    private final ShardStatistics shards;
    private final HitsMetadata<TDocument> hits;
    private final Map<String, JsonData> fields;
    @Nullable
    private final Double maxScore;
    @Nullable
    private final JsonpSerializer<TDocument> tDocumentSerializer;
    public static final JsonpDeserializer<KnnSearchResponse<Object>> _DESERIALIZER = JsonpDeserializer.lazy(() -> KnnSearchResponse.createKnnSearchResponseDeserializer(new NamedDeserializer("co.elastic.clients:Deserializer:_global.knn_search.Response.TDocument")));

    private KnnSearchResponse(Builder<TDocument> builder) {
        this.took = ApiTypeHelper.requireNonNull(builder.took, (Object)this, "took", 0L);
        this.timedOut = ApiTypeHelper.requireNonNull(builder.timedOut, (Object)this, "timedOut", false);
        this.shards = ApiTypeHelper.requireNonNull(builder.shards, this, "shards");
        this.hits = ApiTypeHelper.requireNonNull(builder.hits, this, "hits");
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.maxScore = builder.maxScore;
        this.tDocumentSerializer = builder.tDocumentSerializer;
    }

    public static <TDocument> KnnSearchResponse<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<KnnSearchResponse<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long took() {
        return this.took;
    }

    public final boolean timedOut() {
        return this.timedOut;
    }

    public final ShardStatistics shards() {
        return this.shards;
    }

    public final HitsMetadata<TDocument> hits() {
        return this.hits;
    }

    public final Map<String, JsonData> fields() {
        return this.fields;
    }

    @Nullable
    public final Double maxScore() {
        return this.maxScore;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("took");
        generator.write(this.took);
        generator.writeKey("timed_out");
        generator.write(this.timedOut);
        generator.writeKey("_shards");
        this.shards.serialize(generator, mapper);
        generator.writeKey("hits");
        this.hits.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.fields.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxScore != null) {
            generator.writeKey("max_score");
            generator.write(this.maxScore.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public static <TDocument> JsonpDeserializer<KnnSearchResponse<TDocument>> createKnnSearchResponseDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> KnnSearchResponse.setupKnnSearchResponseDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupKnnSearchResponseDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        op.add(Builder::took, JsonpDeserializer.longDeserializer(), "took");
        op.add(Builder::timedOut, JsonpDeserializer.booleanDeserializer(), "timed_out");
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "_shards");
        op.add(Builder::hits, HitsMetadata.createHitsMetadataDeserializer(tDocumentDeserializer), "hits");
        op.add(Builder::fields, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "fields");
        op.add(Builder::maxScore, JsonpDeserializer.doubleDeserializer(), "max_score");
    }

    public static class Builder<TDocument>
    extends WithJsonObjectBuilderBase<Builder<TDocument>>
    implements ObjectBuilder<KnnSearchResponse<TDocument>> {
        private Long took;
        private Boolean timedOut;
        private ShardStatistics shards;
        private HitsMetadata<TDocument> hits;
        @Nullable
        private Map<String, JsonData> fields;
        @Nullable
        private Double maxScore;
        @Nullable
        private JsonpSerializer<TDocument> tDocumentSerializer;

        public final Builder<TDocument> took(long value) {
            this.took = value;
            return this;
        }

        public final Builder<TDocument> timedOut(boolean value) {
            this.timedOut = value;
            return this;
        }

        public final Builder<TDocument> shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public final Builder<TDocument> shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        public final Builder<TDocument> hits(HitsMetadata<TDocument> value) {
            this.hits = value;
            return this;
        }

        public final Builder<TDocument> hits(Function<HitsMetadata.Builder<TDocument>, ObjectBuilder<HitsMetadata<TDocument>>> fn) {
            return this.hits(fn.apply(new HitsMetadata.Builder()).build());
        }

        public final Builder<TDocument> fields(Map<String, JsonData> map) {
            this.fields = Builder._mapPutAll(this.fields, map);
            return this;
        }

        public final Builder<TDocument> fields(String key, JsonData value) {
            this.fields = Builder._mapPut(this.fields, key, value);
            return this;
        }

        public final Builder<TDocument> maxScore(@Nullable Double value) {
            this.maxScore = value;
            return this;
        }

        public final Builder<TDocument> tDocumentSerializer(@Nullable JsonpSerializer<TDocument> value) {
            this.tDocumentSerializer = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public KnnSearchResponse<TDocument> build() {
            this._checkSingleUse();
            return new KnnSearchResponse(this);
        }
    }
}

