/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch.search_application.SearchApplicationParameters;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SearchApplication
extends SearchApplicationParameters {
    private final String name;
    private final long updatedAtMillis;
    public static final JsonpDeserializer<SearchApplication> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SearchApplication::setupSearchApplicationDeserializer);

    protected SearchApplication(AbstractBuilder<?> builder) {
        super(builder);
        this.name = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).name, this, "name");
        this.updatedAtMillis = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).updatedAtMillis, this, "updatedAtMillis");
    }

    public static SearchApplication searchApplicationOf(Function<Builder, ObjectBuilder<SearchApplication>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final long updatedAtMillis() {
        return this.updatedAtMillis;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("updated_at_millis");
        generator.write(this.updatedAtMillis);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupSearchApplicationDeserializer(ObjectDeserializer<BuilderT> op) {
        SearchApplicationParameters.setupSearchApplicationParametersDeserializer(op);
        op.add(AbstractBuilder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(AbstractBuilder::updatedAtMillis, JsonpDeserializer.longDeserializer(), "updated_at_millis");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends SearchApplicationParameters.AbstractBuilder<BuilderT> {
        private String name;
        private Long updatedAtMillis;

        public final BuilderT name(String value) {
            this.name = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT updatedAtMillis(long value) {
            this.updatedAtMillis = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<SearchApplication> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SearchApplication build() {
            this._checkSingleUse();
            return new SearchApplication(this);
        }
    }
}

