/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.search_application;

import co.elastic.clients.elasticsearch.search_application.SearchApplication;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ListResponse
implements JsonpSerializable {
    private final long count;
    private final List<SearchApplication> results;
    public static final JsonpDeserializer<ListResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListResponse::setupListResponseDeserializer);

    private ListResponse(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.results = ApiTypeHelper.unmodifiableRequired(builder.results, (Object)this, "results");
    }

    public static ListResponse of(Function<Builder, ObjectBuilder<ListResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final List<SearchApplication> results() {
        return this.results;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.results)) {
            generator.writeKey("results");
            generator.writeStartArray();
            for (SearchApplication item0 : this.results) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupListResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::results, JsonpDeserializer.arrayDeserializer(SearchApplication._DESERIALIZER), "results");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ListResponse> {
        private Long count;
        private List<SearchApplication> results;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder results(List<SearchApplication> list) {
            this.results = Builder._listAddAll(this.results, list);
            return this;
        }

        public final Builder results(SearchApplication value, SearchApplication ... values) {
            this.results = Builder._listAdd(this.results, value, values);
            return this;
        }

        public final Builder results(Function<SearchApplication.Builder, ObjectBuilder<SearchApplication>> fn) {
            return this.results(fn.apply(new SearchApplication.Builder()).build(), new SearchApplication[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListResponse build() {
            this._checkSingleUse();
            return new ListResponse(this);
        }
    }
}

