/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FileSettingsIndicatorDetails
implements JsonpSerializable {
    private final long failureStreak;
    private final String mostRecentFailure;
    public static final JsonpDeserializer<FileSettingsIndicatorDetails> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSettingsIndicatorDetails::setupFileSettingsIndicatorDetailsDeserializer);

    private FileSettingsIndicatorDetails(Builder builder) {
        this.failureStreak = ApiTypeHelper.requireNonNull(builder.failureStreak, this, "failureStreak");
        this.mostRecentFailure = ApiTypeHelper.requireNonNull(builder.mostRecentFailure, this, "mostRecentFailure");
    }

    public static FileSettingsIndicatorDetails of(Function<Builder, ObjectBuilder<FileSettingsIndicatorDetails>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long failureStreak() {
        return this.failureStreak;
    }

    public final String mostRecentFailure() {
        return this.mostRecentFailure;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("failure_streak");
        generator.write(this.failureStreak);
        generator.writeKey("most_recent_failure");
        generator.write(this.mostRecentFailure);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFileSettingsIndicatorDetailsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::failureStreak, JsonpDeserializer.longDeserializer(), "failure_streak");
        op.add(Builder::mostRecentFailure, JsonpDeserializer.stringDeserializer(), "most_recent_failure");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FileSettingsIndicatorDetails> {
        private Long failureStreak;
        private String mostRecentFailure;

        public final Builder failureStreak(long value) {
            this.failureStreak = value;
            return this;
        }

        public final Builder mostRecentFailure(String value) {
            this.mostRecentFailure = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FileSettingsIndicatorDetails build() {
            this._checkSingleUse();
            return new FileSettingsIndicatorDetails(this);
        }
    }
}

