/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.mapping;

import co.elastic.clients.elasticsearch._types.mapping.PropertyBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CorePropertyBase
extends PropertyBase {
    private final List<String> copyTo;
    @Nullable
    private final String similarity;
    @Nullable
    private final Boolean store;

    protected CorePropertyBase(AbstractBuilder<?> builder) {
        super(builder);
        this.copyTo = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).copyTo);
        this.similarity = ((AbstractBuilder)builder).similarity;
        this.store = ((AbstractBuilder)builder).store;
    }

    public final List<String> copyTo() {
        return this.copyTo;
    }

    @Nullable
    public final String similarity() {
        return this.similarity;
    }

    @Nullable
    public final Boolean store() {
        return this.store;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.copyTo)) {
            generator.writeKey("copy_to");
            generator.writeStartArray();
            for (String item0 : this.copyTo) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            generator.write(this.similarity);
        }
        if (this.store != null) {
            generator.writeKey("store");
            generator.write(this.store.booleanValue());
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCorePropertyBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(AbstractBuilder::copyTo, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "copy_to");
        op.add(AbstractBuilder::similarity, JsonpDeserializer.stringDeserializer(), "similarity");
        op.add(AbstractBuilder::store, JsonpDeserializer.booleanDeserializer(), "store");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends PropertyBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> copyTo;
        @Nullable
        private String similarity;
        @Nullable
        private Boolean store;

        public final BuilderT copyTo(List<String> list) {
            this.copyTo = AbstractBuilder._listAddAll(this.copyTo, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT copyTo(String value, String ... values) {
            this.copyTo = AbstractBuilder._listAdd(this.copyTo, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT similarity(@Nullable String value) {
            this.similarity = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT store(@Nullable Boolean value) {
            this.store = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

