/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.CreateServiceTokenResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class CreateServiceTokenRequest
extends RequestBase {
    @Nullable
    private final String name;
    private final String namespace;
    @Nullable
    private final Refresh refresh;
    private final String service;
    public static final Endpoint<CreateServiceTokenRequest, CreateServiceTokenResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<CreateServiceTokenRequest, CreateServiceTokenResponse>("es/security.create_service_token", request -> {
        boolean _service = true;
        int _namespace = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.name() != null) {
            propsSet |= 4;
        }
        if (propsSet == 7) {
            return "PUT";
        }
        if (propsSet == 3) {
            return "POST";
        }
        throw SimpleEndpoint.noPathTemplateFound("method");
    }, request -> {
        boolean _service = true;
        int _namespace = 2;
        int _name = 4;
        int propsSet = 0;
        propsSet |= 1;
        propsSet |= 2;
        if (request.name() != null) {
            propsSet |= 4;
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/service");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.namespace, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.service, buf);
            buf.append("/credential");
            buf.append("/token");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CreateServiceTokenResponse._DESERIALIZER);

    private CreateServiceTokenRequest(Builder builder) {
        this.name = builder.name;
        this.namespace = ApiTypeHelper.requireNonNull(builder.namespace, this, "namespace");
        this.refresh = builder.refresh;
        this.service = ApiTypeHelper.requireNonNull(builder.service, this, "service");
    }

    public static CreateServiceTokenRequest of(Function<Builder, ObjectBuilder<CreateServiceTokenRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    public final String namespace() {
        return this.namespace;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    public final String service() {
        return this.service;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CreateServiceTokenRequest> {
        @Nullable
        private String name;
        private String namespace;
        @Nullable
        private Refresh refresh;
        private String service;

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder namespace(String value) {
            this.namespace = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder service(String value) {
            this.service = value;
            return this;
        }

        @Override
        public CreateServiceTokenRequest build() {
            this._checkSingleUse();
            return new CreateServiceTokenRequest(this);
        }
    }
}

