/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.AnomalyCause;
import co.elastic.clients.elasticsearch.ml.Influence;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Anomaly
implements JsonpSerializable {
    private final List<Double> actual;
    private final long bucketSpan;
    @Nullable
    private final String byFieldName;
    @Nullable
    private final String byFieldValue;
    private final List<AnomalyCause> causes;
    private final int detectorIndex;
    @Nullable
    private final String fieldName;
    @Nullable
    private final String function;
    @Nullable
    private final String functionDescription;
    private final List<Influence> influencers;
    private final double initialRecordScore;
    private final boolean isInterim;
    private final String jobId;
    @Nullable
    private final String overFieldName;
    @Nullable
    private final String overFieldValue;
    @Nullable
    private final String partitionFieldName;
    @Nullable
    private final String partitionFieldValue;
    private final double probability;
    private final double recordScore;
    private final String resultType;
    private final long timestamp;
    private final List<Double> typical;
    public static final JsonpDeserializer<Anomaly> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Anomaly::setupAnomalyDeserializer);

    private Anomaly(Builder builder) {
        this.actual = ApiTypeHelper.unmodifiable(builder.actual);
        this.bucketSpan = ApiTypeHelper.requireNonNull(builder.bucketSpan, this, "bucketSpan");
        this.byFieldName = builder.byFieldName;
        this.byFieldValue = builder.byFieldValue;
        this.causes = ApiTypeHelper.unmodifiable(builder.causes);
        this.detectorIndex = ApiTypeHelper.requireNonNull(builder.detectorIndex, this, "detectorIndex");
        this.fieldName = builder.fieldName;
        this.function = builder.function;
        this.functionDescription = builder.functionDescription;
        this.influencers = ApiTypeHelper.unmodifiable(builder.influencers);
        this.initialRecordScore = ApiTypeHelper.requireNonNull(builder.initialRecordScore, this, "initialRecordScore");
        this.isInterim = ApiTypeHelper.requireNonNull(builder.isInterim, this, "isInterim");
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.overFieldName = builder.overFieldName;
        this.overFieldValue = builder.overFieldValue;
        this.partitionFieldName = builder.partitionFieldName;
        this.partitionFieldValue = builder.partitionFieldValue;
        this.probability = ApiTypeHelper.requireNonNull(builder.probability, this, "probability");
        this.recordScore = ApiTypeHelper.requireNonNull(builder.recordScore, this, "recordScore");
        this.resultType = ApiTypeHelper.requireNonNull(builder.resultType, this, "resultType");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.typical = ApiTypeHelper.unmodifiable(builder.typical);
    }

    public static Anomaly of(Function<Builder, ObjectBuilder<Anomaly>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<Double> actual() {
        return this.actual;
    }

    public final long bucketSpan() {
        return this.bucketSpan;
    }

    @Nullable
    public final String byFieldName() {
        return this.byFieldName;
    }

    @Nullable
    public final String byFieldValue() {
        return this.byFieldValue;
    }

    public final List<AnomalyCause> causes() {
        return this.causes;
    }

    public final int detectorIndex() {
        return this.detectorIndex;
    }

    @Nullable
    public final String fieldName() {
        return this.fieldName;
    }

    @Nullable
    public final String function() {
        return this.function;
    }

    @Nullable
    public final String functionDescription() {
        return this.functionDescription;
    }

    public final List<Influence> influencers() {
        return this.influencers;
    }

    public final double initialRecordScore() {
        return this.initialRecordScore;
    }

    public final boolean isInterim() {
        return this.isInterim;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Nullable
    public final String overFieldName() {
        return this.overFieldName;
    }

    @Nullable
    public final String overFieldValue() {
        return this.overFieldValue;
    }

    @Nullable
    public final String partitionFieldName() {
        return this.partitionFieldName;
    }

    @Nullable
    public final String partitionFieldValue() {
        return this.partitionFieldValue;
    }

    public final double probability() {
        return this.probability;
    }

    public final double recordScore() {
        return this.recordScore;
    }

    public final String resultType() {
        return this.resultType;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    public final List<Double> typical() {
        return this.typical;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actual)) {
            generator.writeKey("actual");
            generator.writeStartArray();
            for (Double d : this.actual) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
        generator.writeKey("bucket_span");
        generator.write(this.bucketSpan);
        if (this.byFieldName != null) {
            generator.writeKey("by_field_name");
            generator.write(this.byFieldName);
        }
        if (this.byFieldValue != null) {
            generator.writeKey("by_field_value");
            generator.write(this.byFieldValue);
        }
        if (ApiTypeHelper.isDefined(this.causes)) {
            generator.writeKey("causes");
            generator.writeStartArray();
            for (AnomalyCause anomalyCause : this.causes) {
                anomalyCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("detector_index");
        generator.write(this.detectorIndex);
        if (this.fieldName != null) {
            generator.writeKey("field_name");
            generator.write(this.fieldName);
        }
        if (this.function != null) {
            generator.writeKey("function");
            generator.write(this.function);
        }
        if (this.functionDescription != null) {
            generator.writeKey("function_description");
            generator.write(this.functionDescription);
        }
        if (ApiTypeHelper.isDefined(this.influencers)) {
            generator.writeKey("influencers");
            generator.writeStartArray();
            for (Influence influence : this.influencers) {
                influence.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("initial_record_score");
        generator.write(this.initialRecordScore);
        generator.writeKey("is_interim");
        generator.write(this.isInterim);
        generator.writeKey("job_id");
        generator.write(this.jobId);
        if (this.overFieldName != null) {
            generator.writeKey("over_field_name");
            generator.write(this.overFieldName);
        }
        if (this.overFieldValue != null) {
            generator.writeKey("over_field_value");
            generator.write(this.overFieldValue);
        }
        if (this.partitionFieldName != null) {
            generator.writeKey("partition_field_name");
            generator.write(this.partitionFieldName);
        }
        if (this.partitionFieldValue != null) {
            generator.writeKey("partition_field_value");
            generator.write(this.partitionFieldValue);
        }
        generator.writeKey("probability");
        generator.write(this.probability);
        generator.writeKey("record_score");
        generator.write(this.recordScore);
        generator.writeKey("result_type");
        generator.write(this.resultType);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        if (ApiTypeHelper.isDefined(this.typical)) {
            generator.writeKey("typical");
            generator.writeStartArray();
            for (Double d : this.typical) {
                generator.write(d.doubleValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAnomalyDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actual, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "actual");
        op.add(Builder::bucketSpan, JsonpDeserializer.longDeserializer(), "bucket_span");
        op.add(Builder::byFieldName, JsonpDeserializer.stringDeserializer(), "by_field_name");
        op.add(Builder::byFieldValue, JsonpDeserializer.stringDeserializer(), "by_field_value");
        op.add(Builder::causes, JsonpDeserializer.arrayDeserializer(AnomalyCause._DESERIALIZER), "causes");
        op.add(Builder::detectorIndex, JsonpDeserializer.integerDeserializer(), "detector_index");
        op.add(Builder::fieldName, JsonpDeserializer.stringDeserializer(), "field_name");
        op.add(Builder::function, JsonpDeserializer.stringDeserializer(), "function");
        op.add(Builder::functionDescription, JsonpDeserializer.stringDeserializer(), "function_description");
        op.add(Builder::influencers, JsonpDeserializer.arrayDeserializer(Influence._DESERIALIZER), "influencers");
        op.add(Builder::initialRecordScore, JsonpDeserializer.doubleDeserializer(), "initial_record_score");
        op.add(Builder::isInterim, JsonpDeserializer.booleanDeserializer(), "is_interim");
        op.add(Builder::jobId, JsonpDeserializer.stringDeserializer(), "job_id");
        op.add(Builder::overFieldName, JsonpDeserializer.stringDeserializer(), "over_field_name");
        op.add(Builder::overFieldValue, JsonpDeserializer.stringDeserializer(), "over_field_value");
        op.add(Builder::partitionFieldName, JsonpDeserializer.stringDeserializer(), "partition_field_name");
        op.add(Builder::partitionFieldValue, JsonpDeserializer.stringDeserializer(), "partition_field_value");
        op.add(Builder::probability, JsonpDeserializer.doubleDeserializer(), "probability");
        op.add(Builder::recordScore, JsonpDeserializer.doubleDeserializer(), "record_score");
        op.add(Builder::resultType, JsonpDeserializer.stringDeserializer(), "result_type");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::typical, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer()), "typical");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Anomaly> {
        @Nullable
        private List<Double> actual;
        private Long bucketSpan;
        @Nullable
        private String byFieldName;
        @Nullable
        private String byFieldValue;
        @Nullable
        private List<AnomalyCause> causes;
        private Integer detectorIndex;
        @Nullable
        private String fieldName;
        @Nullable
        private String function;
        @Nullable
        private String functionDescription;
        @Nullable
        private List<Influence> influencers;
        private Double initialRecordScore;
        private Boolean isInterim;
        private String jobId;
        @Nullable
        private String overFieldName;
        @Nullable
        private String overFieldValue;
        @Nullable
        private String partitionFieldName;
        @Nullable
        private String partitionFieldValue;
        private Double probability;
        private Double recordScore;
        private String resultType;
        private Long timestamp;
        @Nullable
        private List<Double> typical;

        public final Builder actual(List<Double> list) {
            this.actual = Builder._listAddAll(this.actual, list);
            return this;
        }

        public final Builder actual(Double value, Double ... values) {
            this.actual = Builder._listAdd(this.actual, value, values);
            return this;
        }

        public final Builder bucketSpan(long value) {
            this.bucketSpan = value;
            return this;
        }

        public final Builder byFieldName(@Nullable String value) {
            this.byFieldName = value;
            return this;
        }

        public final Builder byFieldValue(@Nullable String value) {
            this.byFieldValue = value;
            return this;
        }

        public final Builder causes(List<AnomalyCause> list) {
            this.causes = Builder._listAddAll(this.causes, list);
            return this;
        }

        public final Builder causes(AnomalyCause value, AnomalyCause ... values) {
            this.causes = Builder._listAdd(this.causes, value, values);
            return this;
        }

        public final Builder causes(Function<AnomalyCause.Builder, ObjectBuilder<AnomalyCause>> fn) {
            return this.causes(fn.apply(new AnomalyCause.Builder()).build(), new AnomalyCause[0]);
        }

        public final Builder detectorIndex(int value) {
            this.detectorIndex = value;
            return this;
        }

        public final Builder fieldName(@Nullable String value) {
            this.fieldName = value;
            return this;
        }

        public final Builder function(@Nullable String value) {
            this.function = value;
            return this;
        }

        public final Builder functionDescription(@Nullable String value) {
            this.functionDescription = value;
            return this;
        }

        public final Builder influencers(List<Influence> list) {
            this.influencers = Builder._listAddAll(this.influencers, list);
            return this;
        }

        public final Builder influencers(Influence value, Influence ... values) {
            this.influencers = Builder._listAdd(this.influencers, value, values);
            return this;
        }

        public final Builder influencers(Function<Influence.Builder, ObjectBuilder<Influence>> fn) {
            return this.influencers(fn.apply(new Influence.Builder()).build(), new Influence[0]);
        }

        public final Builder initialRecordScore(double value) {
            this.initialRecordScore = value;
            return this;
        }

        public final Builder isInterim(boolean value) {
            this.isInterim = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder overFieldName(@Nullable String value) {
            this.overFieldName = value;
            return this;
        }

        public final Builder overFieldValue(@Nullable String value) {
            this.overFieldValue = value;
            return this;
        }

        public final Builder partitionFieldName(@Nullable String value) {
            this.partitionFieldName = value;
            return this;
        }

        public final Builder partitionFieldValue(@Nullable String value) {
            this.partitionFieldValue = value;
            return this;
        }

        public final Builder probability(double value) {
            this.probability = value;
            return this;
        }

        public final Builder recordScore(double value) {
            this.recordScore = value;
            return this;
        }

        public final Builder resultType(String value) {
            this.resultType = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder typical(List<Double> list) {
            this.typical = Builder._listAddAll(this.typical, list);
            return this;
        }

        public final Builder typical(Double value, Double ... values) {
            this.typical = Builder._listAdd(this.typical, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Anomaly build() {
            this._checkSingleUse();
            return new Anomaly(this);
        }
    }
}

