/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GetStatsResponse
implements JsonpSerializable {
    private final String retentionDeletionTime;
    private final DateTime retentionDeletionTimeMillis;
    private final long retentionFailed;
    private final long retentionRuns;
    private final long retentionTimedOut;
    private final long totalSnapshotsDeleted;
    private final long totalSnapshotDeletionFailures;
    private final long totalSnapshotsFailed;
    private final long totalSnapshotsTaken;
    private final List<String> policyStats;
    public static final JsonpDeserializer<GetStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetStatsResponse::setupGetStatsResponseDeserializer);

    private GetStatsResponse(Builder builder) {
        this.retentionDeletionTime = ApiTypeHelper.requireNonNull(builder.retentionDeletionTime, this, "retentionDeletionTime");
        this.retentionDeletionTimeMillis = ApiTypeHelper.requireNonNull(builder.retentionDeletionTimeMillis, this, "retentionDeletionTimeMillis");
        this.retentionFailed = ApiTypeHelper.requireNonNull(builder.retentionFailed, this, "retentionFailed");
        this.retentionRuns = ApiTypeHelper.requireNonNull(builder.retentionRuns, this, "retentionRuns");
        this.retentionTimedOut = ApiTypeHelper.requireNonNull(builder.retentionTimedOut, this, "retentionTimedOut");
        this.totalSnapshotsDeleted = ApiTypeHelper.requireNonNull(builder.totalSnapshotsDeleted, this, "totalSnapshotsDeleted");
        this.totalSnapshotDeletionFailures = ApiTypeHelper.requireNonNull(builder.totalSnapshotDeletionFailures, this, "totalSnapshotDeletionFailures");
        this.totalSnapshotsFailed = ApiTypeHelper.requireNonNull(builder.totalSnapshotsFailed, this, "totalSnapshotsFailed");
        this.totalSnapshotsTaken = ApiTypeHelper.requireNonNull(builder.totalSnapshotsTaken, this, "totalSnapshotsTaken");
        this.policyStats = ApiTypeHelper.unmodifiableRequired(builder.policyStats, (Object)this, "policyStats");
    }

    public static GetStatsResponse of(Function<Builder, ObjectBuilder<GetStatsResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String retentionDeletionTime() {
        return this.retentionDeletionTime;
    }

    public final DateTime retentionDeletionTimeMillis() {
        return this.retentionDeletionTimeMillis;
    }

    public final long retentionFailed() {
        return this.retentionFailed;
    }

    public final long retentionRuns() {
        return this.retentionRuns;
    }

    public final long retentionTimedOut() {
        return this.retentionTimedOut;
    }

    public final long totalSnapshotsDeleted() {
        return this.totalSnapshotsDeleted;
    }

    public final long totalSnapshotDeletionFailures() {
        return this.totalSnapshotDeletionFailures;
    }

    public final long totalSnapshotsFailed() {
        return this.totalSnapshotsFailed;
    }

    public final long totalSnapshotsTaken() {
        return this.totalSnapshotsTaken;
    }

    public final List<String> policyStats() {
        return this.policyStats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("retention_deletion_time");
        generator.write(this.retentionDeletionTime);
        generator.writeKey("retention_deletion_time_millis");
        this.retentionDeletionTimeMillis.serialize(generator, mapper);
        generator.writeKey("retention_failed");
        generator.write(this.retentionFailed);
        generator.writeKey("retention_runs");
        generator.write(this.retentionRuns);
        generator.writeKey("retention_timed_out");
        generator.write(this.retentionTimedOut);
        generator.writeKey("total_snapshots_deleted");
        generator.write(this.totalSnapshotsDeleted);
        generator.writeKey("total_snapshot_deletion_failures");
        generator.write(this.totalSnapshotDeletionFailures);
        generator.writeKey("total_snapshots_failed");
        generator.write(this.totalSnapshotsFailed);
        generator.writeKey("total_snapshots_taken");
        generator.write(this.totalSnapshotsTaken);
        if (ApiTypeHelper.isDefined(this.policyStats)) {
            generator.writeKey("policy_stats");
            generator.writeStartArray();
            for (String item0 : this.policyStats) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupGetStatsResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::retentionDeletionTime, JsonpDeserializer.stringDeserializer(), "retention_deletion_time");
        op.add(Builder::retentionDeletionTimeMillis, DateTime._DESERIALIZER, "retention_deletion_time_millis");
        op.add(Builder::retentionFailed, JsonpDeserializer.longDeserializer(), "retention_failed");
        op.add(Builder::retentionRuns, JsonpDeserializer.longDeserializer(), "retention_runs");
        op.add(Builder::retentionTimedOut, JsonpDeserializer.longDeserializer(), "retention_timed_out");
        op.add(Builder::totalSnapshotsDeleted, JsonpDeserializer.longDeserializer(), "total_snapshots_deleted");
        op.add(Builder::totalSnapshotDeletionFailures, JsonpDeserializer.longDeserializer(), "total_snapshot_deletion_failures");
        op.add(Builder::totalSnapshotsFailed, JsonpDeserializer.longDeserializer(), "total_snapshots_failed");
        op.add(Builder::totalSnapshotsTaken, JsonpDeserializer.longDeserializer(), "total_snapshots_taken");
        op.add(Builder::policyStats, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "policy_stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<GetStatsResponse> {
        private String retentionDeletionTime;
        private DateTime retentionDeletionTimeMillis;
        private Long retentionFailed;
        private Long retentionRuns;
        private Long retentionTimedOut;
        private Long totalSnapshotsDeleted;
        private Long totalSnapshotDeletionFailures;
        private Long totalSnapshotsFailed;
        private Long totalSnapshotsTaken;
        private List<String> policyStats;

        public final Builder retentionDeletionTime(String value) {
            this.retentionDeletionTime = value;
            return this;
        }

        public final Builder retentionDeletionTimeMillis(DateTime value) {
            this.retentionDeletionTimeMillis = value;
            return this;
        }

        public final Builder retentionFailed(long value) {
            this.retentionFailed = value;
            return this;
        }

        public final Builder retentionRuns(long value) {
            this.retentionRuns = value;
            return this;
        }

        public final Builder retentionTimedOut(long value) {
            this.retentionTimedOut = value;
            return this;
        }

        public final Builder totalSnapshotsDeleted(long value) {
            this.totalSnapshotsDeleted = value;
            return this;
        }

        public final Builder totalSnapshotDeletionFailures(long value) {
            this.totalSnapshotDeletionFailures = value;
            return this;
        }

        public final Builder totalSnapshotsFailed(long value) {
            this.totalSnapshotsFailed = value;
            return this;
        }

        public final Builder totalSnapshotsTaken(long value) {
            this.totalSnapshotsTaken = value;
            return this;
        }

        public final Builder policyStats(List<String> list) {
            this.policyStats = Builder._listAddAll(this.policyStats, list);
            return this;
        }

        public final Builder policyStats(String value, String ... values) {
            this.policyStats = Builder._listAdd(this.policyStats, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetStatsResponse build() {
            this._checkSingleUse();
            return new GetStatsResponse(this);
        }
    }
}

