/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.SuggestUserProfilesResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SuggestUserProfilesRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> data;
    @Nullable
    private final String name;
    @Nullable
    private final Long size;
    public static final JsonpDeserializer<SuggestUserProfilesRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestUserProfilesRequest::setupSuggestUserProfilesRequestDeserializer);
    public static final Endpoint<SuggestUserProfilesRequest, SuggestUserProfilesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SuggestUserProfilesRequest, SuggestUserProfilesResponse>("es/security.suggest_user_profiles", request -> "POST", request -> "/_security/profile/_suggest", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (ApiTypeHelper.isDefined(request.data)) {
            params.put("data", request.data.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, SuggestUserProfilesResponse._DESERIALIZER);

    private SuggestUserProfilesRequest(Builder builder) {
        this.data = ApiTypeHelper.unmodifiable(builder.data);
        this.name = builder.name;
        this.size = builder.size;
    }

    public static SuggestUserProfilesRequest of(Function<Builder, ObjectBuilder<SuggestUserProfilesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> data() {
        return this.data;
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final Long size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.longValue());
        }
    }

    protected static void setupSuggestUserProfilesRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SuggestUserProfilesRequest> {
        @Nullable
        private List<String> data;
        @Nullable
        private String name;
        @Nullable
        private Long size;

        public final Builder data(List<String> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        public final Builder data(String value, String ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder size(@Nullable Long value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SuggestUserProfilesRequest build() {
            this._checkSingleUse();
            return new SuggestUserProfilesRequest(this);
        }
    }
}

