/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SuggestFuzziness
implements JsonpSerializable {
    private final String fuzziness;
    private final int minLength;
    private final int prefixLength;
    private final boolean transpositions;
    private final boolean unicodeAware;
    public static final JsonpDeserializer<SuggestFuzziness> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SuggestFuzziness::setupSuggestFuzzinessDeserializer);

    private SuggestFuzziness(Builder builder) {
        this.fuzziness = ApiTypeHelper.requireNonNull(builder.fuzziness, this, "fuzziness");
        this.minLength = ApiTypeHelper.requireNonNull(builder.minLength, this, "minLength");
        this.prefixLength = ApiTypeHelper.requireNonNull(builder.prefixLength, this, "prefixLength");
        this.transpositions = ApiTypeHelper.requireNonNull(builder.transpositions, this, "transpositions");
        this.unicodeAware = ApiTypeHelper.requireNonNull(builder.unicodeAware, this, "unicodeAware");
    }

    public static SuggestFuzziness of(Function<Builder, ObjectBuilder<SuggestFuzziness>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String fuzziness() {
        return this.fuzziness;
    }

    public final int minLength() {
        return this.minLength;
    }

    public final int prefixLength() {
        return this.prefixLength;
    }

    public final boolean transpositions() {
        return this.transpositions;
    }

    public final boolean unicodeAware() {
        return this.unicodeAware;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("fuzziness");
        generator.write(this.fuzziness);
        generator.writeKey("min_length");
        generator.write(this.minLength);
        generator.writeKey("prefix_length");
        generator.write(this.prefixLength);
        generator.writeKey("transpositions");
        generator.write(this.transpositions);
        generator.writeKey("unicode_aware");
        generator.write(this.unicodeAware);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSuggestFuzzinessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fuzziness, JsonpDeserializer.stringDeserializer(), "fuzziness");
        op.add(Builder::minLength, JsonpDeserializer.integerDeserializer(), "min_length");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::transpositions, JsonpDeserializer.booleanDeserializer(), "transpositions");
        op.add(Builder::unicodeAware, JsonpDeserializer.booleanDeserializer(), "unicode_aware");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SuggestFuzziness> {
        private String fuzziness;
        private Integer minLength;
        private Integer prefixLength;
        private Boolean transpositions;
        private Boolean unicodeAware;

        public final Builder fuzziness(String value) {
            this.fuzziness = value;
            return this;
        }

        public final Builder minLength(int value) {
            this.minLength = value;
            return this;
        }

        public final Builder prefixLength(int value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder transpositions(boolean value) {
            this.transpositions = value;
            return this;
        }

        public final Builder unicodeAware(boolean value) {
            this.unicodeAware = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SuggestFuzziness build() {
            this._checkSingleUse();
            return new SuggestFuzziness(this);
        }
    }
}

