/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.elasticsearch.indices.stats.ShardFileSizeInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SegmentsStats
implements JsonpSerializable {
    private final int count;
    @Nullable
    private final String docValuesMemory;
    private final int docValuesMemoryInBytes;
    private final Map<String, ShardFileSizeInfo> fileSizes;
    @Nullable
    private final String fixedBitSet;
    private final int fixedBitSetMemoryInBytes;
    @Nullable
    private final String indexWriterMemory;
    @Nullable
    private final Integer indexWriterMaxMemoryInBytes;
    private final int indexWriterMemoryInBytes;
    private final long maxUnsafeAutoIdTimestamp;
    @Nullable
    private final String memory;
    private final int memoryInBytes;
    @Nullable
    private final String normsMemory;
    private final int normsMemoryInBytes;
    @Nullable
    private final String pointsMemory;
    private final int pointsMemoryInBytes;
    @Nullable
    private final String storedMemory;
    private final int storedFieldsMemoryInBytes;
    private final int termsMemoryInBytes;
    @Nullable
    private final String termsMemory;
    @Nullable
    private final String termVectoryMemory;
    private final int termVectorsMemoryInBytes;
    @Nullable
    private final String versionMapMemory;
    private final int versionMapMemoryInBytes;
    public static final JsonpDeserializer<SegmentsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SegmentsStats::setupSegmentsStatsDeserializer);

    private SegmentsStats(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.docValuesMemory = builder.docValuesMemory;
        this.docValuesMemoryInBytes = ApiTypeHelper.requireNonNull(builder.docValuesMemoryInBytes, this, "docValuesMemoryInBytes");
        this.fileSizes = ApiTypeHelper.unmodifiableRequired(builder.fileSizes, (Object)this, "fileSizes");
        this.fixedBitSet = builder.fixedBitSet;
        this.fixedBitSetMemoryInBytes = ApiTypeHelper.requireNonNull(builder.fixedBitSetMemoryInBytes, this, "fixedBitSetMemoryInBytes");
        this.indexWriterMemory = builder.indexWriterMemory;
        this.indexWriterMaxMemoryInBytes = builder.indexWriterMaxMemoryInBytes;
        this.indexWriterMemoryInBytes = ApiTypeHelper.requireNonNull(builder.indexWriterMemoryInBytes, this, "indexWriterMemoryInBytes");
        this.maxUnsafeAutoIdTimestamp = ApiTypeHelper.requireNonNull(builder.maxUnsafeAutoIdTimestamp, this, "maxUnsafeAutoIdTimestamp");
        this.memory = builder.memory;
        this.memoryInBytes = ApiTypeHelper.requireNonNull(builder.memoryInBytes, this, "memoryInBytes");
        this.normsMemory = builder.normsMemory;
        this.normsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.normsMemoryInBytes, this, "normsMemoryInBytes");
        this.pointsMemory = builder.pointsMemory;
        this.pointsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.pointsMemoryInBytes, this, "pointsMemoryInBytes");
        this.storedMemory = builder.storedMemory;
        this.storedFieldsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.storedFieldsMemoryInBytes, this, "storedFieldsMemoryInBytes");
        this.termsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.termsMemoryInBytes, this, "termsMemoryInBytes");
        this.termsMemory = builder.termsMemory;
        this.termVectoryMemory = builder.termVectoryMemory;
        this.termVectorsMemoryInBytes = ApiTypeHelper.requireNonNull(builder.termVectorsMemoryInBytes, this, "termVectorsMemoryInBytes");
        this.versionMapMemory = builder.versionMapMemory;
        this.versionMapMemoryInBytes = ApiTypeHelper.requireNonNull(builder.versionMapMemoryInBytes, this, "versionMapMemoryInBytes");
    }

    public static SegmentsStats of(Function<Builder, ObjectBuilder<SegmentsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int count() {
        return this.count;
    }

    @Nullable
    public final String docValuesMemory() {
        return this.docValuesMemory;
    }

    public final int docValuesMemoryInBytes() {
        return this.docValuesMemoryInBytes;
    }

    public final Map<String, ShardFileSizeInfo> fileSizes() {
        return this.fileSizes;
    }

    @Nullable
    public final String fixedBitSet() {
        return this.fixedBitSet;
    }

    public final int fixedBitSetMemoryInBytes() {
        return this.fixedBitSetMemoryInBytes;
    }

    @Nullable
    public final String indexWriterMemory() {
        return this.indexWriterMemory;
    }

    @Nullable
    public final Integer indexWriterMaxMemoryInBytes() {
        return this.indexWriterMaxMemoryInBytes;
    }

    public final int indexWriterMemoryInBytes() {
        return this.indexWriterMemoryInBytes;
    }

    public final long maxUnsafeAutoIdTimestamp() {
        return this.maxUnsafeAutoIdTimestamp;
    }

    @Nullable
    public final String memory() {
        return this.memory;
    }

    public final int memoryInBytes() {
        return this.memoryInBytes;
    }

    @Nullable
    public final String normsMemory() {
        return this.normsMemory;
    }

    public final int normsMemoryInBytes() {
        return this.normsMemoryInBytes;
    }

    @Nullable
    public final String pointsMemory() {
        return this.pointsMemory;
    }

    public final int pointsMemoryInBytes() {
        return this.pointsMemoryInBytes;
    }

    @Nullable
    public final String storedMemory() {
        return this.storedMemory;
    }

    public final int storedFieldsMemoryInBytes() {
        return this.storedFieldsMemoryInBytes;
    }

    public final int termsMemoryInBytes() {
        return this.termsMemoryInBytes;
    }

    @Nullable
    public final String termsMemory() {
        return this.termsMemory;
    }

    @Nullable
    public final String termVectoryMemory() {
        return this.termVectoryMemory;
    }

    public final int termVectorsMemoryInBytes() {
        return this.termVectorsMemoryInBytes;
    }

    @Nullable
    public final String versionMapMemory() {
        return this.versionMapMemory;
    }

    public final int versionMapMemoryInBytes() {
        return this.versionMapMemoryInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (this.docValuesMemory != null) {
            generator.writeKey("doc_values_memory");
            generator.write(this.docValuesMemory);
        }
        generator.writeKey("doc_values_memory_in_bytes");
        generator.write(this.docValuesMemoryInBytes);
        if (ApiTypeHelper.isDefined(this.fileSizes)) {
            generator.writeKey("file_sizes");
            generator.writeStartObject();
            for (Map.Entry<String, ShardFileSizeInfo> item0 : this.fileSizes.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.fixedBitSet != null) {
            generator.writeKey("fixed_bit_set");
            generator.write(this.fixedBitSet);
        }
        generator.writeKey("fixed_bit_set_memory_in_bytes");
        generator.write(this.fixedBitSetMemoryInBytes);
        if (this.indexWriterMemory != null) {
            generator.writeKey("index_writer_memory");
            generator.write(this.indexWriterMemory);
        }
        if (this.indexWriterMaxMemoryInBytes != null) {
            generator.writeKey("index_writer_max_memory_in_bytes");
            generator.write(this.indexWriterMaxMemoryInBytes.intValue());
        }
        generator.writeKey("index_writer_memory_in_bytes");
        generator.write(this.indexWriterMemoryInBytes);
        generator.writeKey("max_unsafe_auto_id_timestamp");
        generator.write(this.maxUnsafeAutoIdTimestamp);
        if (this.memory != null) {
            generator.writeKey("memory");
            generator.write(this.memory);
        }
        generator.writeKey("memory_in_bytes");
        generator.write(this.memoryInBytes);
        if (this.normsMemory != null) {
            generator.writeKey("norms_memory");
            generator.write(this.normsMemory);
        }
        generator.writeKey("norms_memory_in_bytes");
        generator.write(this.normsMemoryInBytes);
        if (this.pointsMemory != null) {
            generator.writeKey("points_memory");
            generator.write(this.pointsMemory);
        }
        generator.writeKey("points_memory_in_bytes");
        generator.write(this.pointsMemoryInBytes);
        if (this.storedMemory != null) {
            generator.writeKey("stored_memory");
            generator.write(this.storedMemory);
        }
        generator.writeKey("stored_fields_memory_in_bytes");
        generator.write(this.storedFieldsMemoryInBytes);
        generator.writeKey("terms_memory_in_bytes");
        generator.write(this.termsMemoryInBytes);
        if (this.termsMemory != null) {
            generator.writeKey("terms_memory");
            generator.write(this.termsMemory);
        }
        if (this.termVectoryMemory != null) {
            generator.writeKey("term_vectory_memory");
            generator.write(this.termVectoryMemory);
        }
        generator.writeKey("term_vectors_memory_in_bytes");
        generator.write(this.termVectorsMemoryInBytes);
        if (this.versionMapMemory != null) {
            generator.writeKey("version_map_memory");
            generator.write(this.versionMapMemory);
        }
        generator.writeKey("version_map_memory_in_bytes");
        generator.write(this.versionMapMemoryInBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSegmentsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.integerDeserializer(), "count");
        op.add(Builder::docValuesMemory, JsonpDeserializer.stringDeserializer(), "doc_values_memory");
        op.add(Builder::docValuesMemoryInBytes, JsonpDeserializer.integerDeserializer(), "doc_values_memory_in_bytes");
        op.add(Builder::fileSizes, JsonpDeserializer.stringMapDeserializer(ShardFileSizeInfo._DESERIALIZER), "file_sizes");
        op.add(Builder::fixedBitSet, JsonpDeserializer.stringDeserializer(), "fixed_bit_set");
        op.add(Builder::fixedBitSetMemoryInBytes, JsonpDeserializer.integerDeserializer(), "fixed_bit_set_memory_in_bytes");
        op.add(Builder::indexWriterMemory, JsonpDeserializer.stringDeserializer(), "index_writer_memory");
        op.add(Builder::indexWriterMaxMemoryInBytes, JsonpDeserializer.integerDeserializer(), "index_writer_max_memory_in_bytes");
        op.add(Builder::indexWriterMemoryInBytes, JsonpDeserializer.integerDeserializer(), "index_writer_memory_in_bytes");
        op.add(Builder::maxUnsafeAutoIdTimestamp, JsonpDeserializer.longDeserializer(), "max_unsafe_auto_id_timestamp");
        op.add(Builder::memory, JsonpDeserializer.stringDeserializer(), "memory");
        op.add(Builder::memoryInBytes, JsonpDeserializer.integerDeserializer(), "memory_in_bytes");
        op.add(Builder::normsMemory, JsonpDeserializer.stringDeserializer(), "norms_memory");
        op.add(Builder::normsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "norms_memory_in_bytes");
        op.add(Builder::pointsMemory, JsonpDeserializer.stringDeserializer(), "points_memory");
        op.add(Builder::pointsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "points_memory_in_bytes");
        op.add(Builder::storedMemory, JsonpDeserializer.stringDeserializer(), "stored_memory");
        op.add(Builder::storedFieldsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "stored_fields_memory_in_bytes");
        op.add(Builder::termsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "terms_memory_in_bytes");
        op.add(Builder::termsMemory, JsonpDeserializer.stringDeserializer(), "terms_memory");
        op.add(Builder::termVectoryMemory, JsonpDeserializer.stringDeserializer(), "term_vectory_memory");
        op.add(Builder::termVectorsMemoryInBytes, JsonpDeserializer.integerDeserializer(), "term_vectors_memory_in_bytes");
        op.add(Builder::versionMapMemory, JsonpDeserializer.stringDeserializer(), "version_map_memory");
        op.add(Builder::versionMapMemoryInBytes, JsonpDeserializer.integerDeserializer(), "version_map_memory_in_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SegmentsStats> {
        private Integer count;
        @Nullable
        private String docValuesMemory;
        private Integer docValuesMemoryInBytes;
        private Map<String, ShardFileSizeInfo> fileSizes;
        @Nullable
        private String fixedBitSet;
        private Integer fixedBitSetMemoryInBytes;
        @Nullable
        private String indexWriterMemory;
        @Nullable
        private Integer indexWriterMaxMemoryInBytes;
        private Integer indexWriterMemoryInBytes;
        private Long maxUnsafeAutoIdTimestamp;
        @Nullable
        private String memory;
        private Integer memoryInBytes;
        @Nullable
        private String normsMemory;
        private Integer normsMemoryInBytes;
        @Nullable
        private String pointsMemory;
        private Integer pointsMemoryInBytes;
        @Nullable
        private String storedMemory;
        private Integer storedFieldsMemoryInBytes;
        private Integer termsMemoryInBytes;
        @Nullable
        private String termsMemory;
        @Nullable
        private String termVectoryMemory;
        private Integer termVectorsMemoryInBytes;
        @Nullable
        private String versionMapMemory;
        private Integer versionMapMemoryInBytes;

        public final Builder count(int value) {
            this.count = value;
            return this;
        }

        public final Builder docValuesMemory(@Nullable String value) {
            this.docValuesMemory = value;
            return this;
        }

        public final Builder docValuesMemoryInBytes(int value) {
            this.docValuesMemoryInBytes = value;
            return this;
        }

        public final Builder fileSizes(Map<String, ShardFileSizeInfo> map) {
            this.fileSizes = Builder._mapPutAll(this.fileSizes, map);
            return this;
        }

        public final Builder fileSizes(String key, ShardFileSizeInfo value) {
            this.fileSizes = Builder._mapPut(this.fileSizes, key, value);
            return this;
        }

        public final Builder fileSizes(String key, Function<ShardFileSizeInfo.Builder, ObjectBuilder<ShardFileSizeInfo>> fn) {
            return this.fileSizes(key, fn.apply(new ShardFileSizeInfo.Builder()).build());
        }

        public final Builder fixedBitSet(@Nullable String value) {
            this.fixedBitSet = value;
            return this;
        }

        public final Builder fixedBitSetMemoryInBytes(int value) {
            this.fixedBitSetMemoryInBytes = value;
            return this;
        }

        public final Builder indexWriterMemory(@Nullable String value) {
            this.indexWriterMemory = value;
            return this;
        }

        public final Builder indexWriterMaxMemoryInBytes(@Nullable Integer value) {
            this.indexWriterMaxMemoryInBytes = value;
            return this;
        }

        public final Builder indexWriterMemoryInBytes(int value) {
            this.indexWriterMemoryInBytes = value;
            return this;
        }

        public final Builder maxUnsafeAutoIdTimestamp(long value) {
            this.maxUnsafeAutoIdTimestamp = value;
            return this;
        }

        public final Builder memory(@Nullable String value) {
            this.memory = value;
            return this;
        }

        public final Builder memoryInBytes(int value) {
            this.memoryInBytes = value;
            return this;
        }

        public final Builder normsMemory(@Nullable String value) {
            this.normsMemory = value;
            return this;
        }

        public final Builder normsMemoryInBytes(int value) {
            this.normsMemoryInBytes = value;
            return this;
        }

        public final Builder pointsMemory(@Nullable String value) {
            this.pointsMemory = value;
            return this;
        }

        public final Builder pointsMemoryInBytes(int value) {
            this.pointsMemoryInBytes = value;
            return this;
        }

        public final Builder storedMemory(@Nullable String value) {
            this.storedMemory = value;
            return this;
        }

        public final Builder storedFieldsMemoryInBytes(int value) {
            this.storedFieldsMemoryInBytes = value;
            return this;
        }

        public final Builder termsMemoryInBytes(int value) {
            this.termsMemoryInBytes = value;
            return this;
        }

        public final Builder termsMemory(@Nullable String value) {
            this.termsMemory = value;
            return this;
        }

        public final Builder termVectoryMemory(@Nullable String value) {
            this.termVectoryMemory = value;
            return this;
        }

        public final Builder termVectorsMemoryInBytes(int value) {
            this.termVectorsMemoryInBytes = value;
            return this;
        }

        public final Builder versionMapMemory(@Nullable String value) {
            this.versionMapMemory = value;
            return this;
        }

        public final Builder versionMapMemoryInBytes(int value) {
            this.versionMapMemoryInBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SegmentsStats build() {
            this._checkSingleUse();
            return new SegmentsStats(this);
        }
    }
}

