/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.elasticsearch.ml.put_trained_model.TrainedModelTreeNode;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelTree
implements JsonpSerializable {
    private final List<String> classificationLabels;
    private final List<String> featureNames;
    @Nullable
    private final String targetType;
    private final List<TrainedModelTreeNode> treeStructure;
    public static final JsonpDeserializer<TrainedModelTree> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelTree::setupTrainedModelTreeDeserializer);

    private TrainedModelTree(Builder builder) {
        this.classificationLabels = ApiTypeHelper.unmodifiable(builder.classificationLabels);
        this.featureNames = ApiTypeHelper.unmodifiableRequired(builder.featureNames, (Object)this, "featureNames");
        this.targetType = builder.targetType;
        this.treeStructure = ApiTypeHelper.unmodifiableRequired(builder.treeStructure, (Object)this, "treeStructure");
    }

    public static TrainedModelTree of(Function<Builder, ObjectBuilder<TrainedModelTree>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> classificationLabels() {
        return this.classificationLabels;
    }

    public final List<String> featureNames() {
        return this.featureNames;
    }

    @Nullable
    public final String targetType() {
        return this.targetType;
    }

    public final List<TrainedModelTreeNode> treeStructure() {
        return this.treeStructure;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.classificationLabels)) {
            generator.writeKey("classification_labels");
            generator.writeStartArray();
            for (String string : this.classificationLabels) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.featureNames)) {
            generator.writeKey("feature_names");
            generator.writeStartArray();
            for (String string : this.featureNames) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.targetType != null) {
            generator.writeKey("target_type");
            generator.write(this.targetType);
        }
        if (ApiTypeHelper.isDefined(this.treeStructure)) {
            generator.writeKey("tree_structure");
            generator.writeStartArray();
            for (TrainedModelTreeNode trainedModelTreeNode : this.treeStructure) {
                trainedModelTreeNode.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTrainedModelTreeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::classificationLabels, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "classification_labels");
        op.add(Builder::featureNames, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "feature_names");
        op.add(Builder::targetType, JsonpDeserializer.stringDeserializer(), "target_type");
        op.add(Builder::treeStructure, JsonpDeserializer.arrayDeserializer(TrainedModelTreeNode._DESERIALIZER), "tree_structure");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelTree> {
        @Nullable
        private List<String> classificationLabels;
        private List<String> featureNames;
        @Nullable
        private String targetType;
        private List<TrainedModelTreeNode> treeStructure;

        public final Builder classificationLabels(List<String> list) {
            this.classificationLabels = Builder._listAddAll(this.classificationLabels, list);
            return this;
        }

        public final Builder classificationLabels(String value, String ... values) {
            this.classificationLabels = Builder._listAdd(this.classificationLabels, value, values);
            return this;
        }

        public final Builder featureNames(List<String> list) {
            this.featureNames = Builder._listAddAll(this.featureNames, list);
            return this;
        }

        public final Builder featureNames(String value, String ... values) {
            this.featureNames = Builder._listAdd(this.featureNames, value, values);
            return this;
        }

        public final Builder targetType(@Nullable String value) {
            this.targetType = value;
            return this;
        }

        public final Builder treeStructure(List<TrainedModelTreeNode> list) {
            this.treeStructure = Builder._listAddAll(this.treeStructure, list);
            return this;
        }

        public final Builder treeStructure(TrainedModelTreeNode value, TrainedModelTreeNode ... values) {
            this.treeStructure = Builder._listAdd(this.treeStructure, value, values);
            return this;
        }

        public final Builder treeStructure(Function<TrainedModelTreeNode.Builder, ObjectBuilder<TrainedModelTreeNode>> fn) {
            return this.treeStructure(fn.apply(new TrainedModelTreeNode.Builder()).build(), new TrainedModelTreeNode[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelTree build() {
            this._checkSingleUse();
            return new TrainedModelTree(this);
        }
    }
}

