/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform.get_node_stats;

import co.elastic.clients.elasticsearch.transform.get_node_stats.TransformNodeStats;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class TransformNodeFullStats
implements JsonpSerializable {
    private final Map<String, TransformNodeStats> nodes;
    private final TransformNodeStats total;

    protected TransformNodeFullStats(AbstractBuilder<?> builder) {
        this.nodes = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).nodes);
        this.total = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).total, this, "total");
    }

    public final Map<String, TransformNodeStats> nodes() {
        return this.nodes;
    }

    public final TransformNodeStats total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, TransformNodeStats> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupTransformNodeFullStatsDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::total, TransformNodeStats._DESERIALIZER, "total");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> builder.nodes((String)name, TransformNodeStats._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper)));
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private Map<String, TransformNodeStats> nodes = new HashMap<String, TransformNodeStats>();
        private TransformNodeStats total;

        public final BuilderT nodes(Map<String, TransformNodeStats> map) {
            this.nodes = AbstractBuilder._mapPutAll(this.nodes, map);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, TransformNodeStats value) {
            this.nodes = AbstractBuilder._mapPut(this.nodes, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT nodes(String key, Function<TransformNodeStats.Builder, ObjectBuilder<TransformNodeStats>> fn) {
            return this.nodes(key, fn.apply(new TransformNodeStats.Builder()).build());
        }

        public final BuilderT total(TransformNodeStats value) {
            this.total = value;
            return (BuilderT)this.self();
        }

        public final BuilderT total(Function<TransformNodeStats.Builder, ObjectBuilder<TransformNodeStats>> fn) {
            return this.total(fn.apply(new TransformNodeStats.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

