/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.CohereEmbeddingType;
import co.elastic.clients.elasticsearch.inference.CohereSimilarityType;
import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CohereServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    @Nullable
    private final CohereEmbeddingType embeddingType;
    @Nullable
    private final String modelId;
    @Nullable
    private final RateLimitSetting rateLimit;
    @Nullable
    private final CohereSimilarityType similarity;
    public static final JsonpDeserializer<CohereServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CohereServiceSettings::setupCohereServiceSettingsDeserializer);

    private CohereServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.embeddingType = builder.embeddingType;
        this.modelId = builder.modelId;
        this.rateLimit = builder.rateLimit;
        this.similarity = builder.similarity;
    }

    public static CohereServiceSettings of(Function<Builder, ObjectBuilder<CohereServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    @Nullable
    public final CohereEmbeddingType embeddingType() {
        return this.embeddingType;
    }

    @Nullable
    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Nullable
    public final CohereSimilarityType similarity() {
        return this.similarity;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        if (this.embeddingType != null) {
            generator.writeKey("embedding_type");
            this.embeddingType.serialize(generator, mapper);
        }
        if (this.modelId != null) {
            generator.writeKey("model_id");
            generator.write(this.modelId);
        }
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            this.similarity.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupCohereServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::embeddingType, CohereEmbeddingType._DESERIALIZER, "embedding_type");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::similarity, CohereSimilarityType._DESERIALIZER, "similarity");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<CohereServiceSettings> {
        private String apiKey;
        @Nullable
        private CohereEmbeddingType embeddingType;
        @Nullable
        private String modelId;
        @Nullable
        private RateLimitSetting rateLimit;
        @Nullable
        private CohereSimilarityType similarity;

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder embeddingType(@Nullable CohereEmbeddingType value) {
            this.embeddingType = value;
            return this;
        }

        public final Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder similarity(@Nullable CohereSimilarityType value) {
            this.similarity = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CohereServiceSettings build() {
            this._checkSingleUse();
            return new CohereServiceSettings(this);
        }
    }
}

