/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UserProfileUser
implements JsonpSerializable {
    @Nullable
    private final String email;
    @Nullable
    private final String fullName;
    private final String realmName;
    @Nullable
    private final String realmDomain;
    private final List<String> roles;
    private final String username;
    public static final JsonpDeserializer<UserProfileUser> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UserProfileUser::setupUserProfileUserDeserializer);

    private UserProfileUser(Builder builder) {
        this.email = builder.email;
        this.fullName = builder.fullName;
        this.realmName = ApiTypeHelper.requireNonNull(builder.realmName, this, "realmName");
        this.realmDomain = builder.realmDomain;
        this.roles = ApiTypeHelper.unmodifiableRequired(builder.roles, (Object)this, "roles");
        this.username = ApiTypeHelper.requireNonNull(builder.username, this, "username");
    }

    public static UserProfileUser of(Function<Builder, ObjectBuilder<UserProfileUser>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String email() {
        return this.email;
    }

    @Nullable
    public final String fullName() {
        return this.fullName;
    }

    public final String realmName() {
        return this.realmName;
    }

    @Nullable
    public final String realmDomain() {
        return this.realmDomain;
    }

    public final List<String> roles() {
        return this.roles;
    }

    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.email != null) {
            generator.writeKey("email");
            generator.write(this.email);
        }
        if (this.fullName != null) {
            generator.writeKey("full_name");
            generator.write(this.fullName);
        }
        generator.writeKey("realm_name");
        generator.write(this.realmName);
        if (this.realmDomain != null) {
            generator.writeKey("realm_domain");
            generator.write(this.realmDomain);
        }
        if (ApiTypeHelper.isDefined(this.roles)) {
            generator.writeKey("roles");
            generator.writeStartArray();
            for (String item0 : this.roles) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("username");
        generator.write(this.username);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupUserProfileUserDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::email, JsonpDeserializer.stringDeserializer(), "email");
        op.add(Builder::fullName, JsonpDeserializer.stringDeserializer(), "full_name");
        op.add(Builder::realmName, JsonpDeserializer.stringDeserializer(), "realm_name");
        op.add(Builder::realmDomain, JsonpDeserializer.stringDeserializer(), "realm_domain");
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "roles");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<UserProfileUser> {
        @Nullable
        private String email;
        @Nullable
        private String fullName;
        private String realmName;
        @Nullable
        private String realmDomain;
        private List<String> roles;
        private String username;

        public final Builder email(@Nullable String value) {
            this.email = value;
            return this;
        }

        public final Builder fullName(@Nullable String value) {
            this.fullName = value;
            return this;
        }

        public final Builder realmName(String value) {
            this.realmName = value;
            return this;
        }

        public final Builder realmDomain(@Nullable String value) {
            this.realmDomain = value;
            return this;
        }

        public final Builder roles(List<String> list) {
            this.roles = Builder._listAddAll(this.roles, list);
            return this;
        }

        public final Builder roles(String value, String ... values) {
            this.roles = Builder._listAdd(this.roles, value, values);
            return this;
        }

        public final Builder username(String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UserProfileUser build() {
            this._checkSingleUse();
            return new UserProfileUser(this);
        }
    }
}

