/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.WatcherActionTotals;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class WatcherActions
implements JsonpSerializable {
    private final Map<String, WatcherActionTotals> actions;
    public static final JsonpDeserializer<WatcherActions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, WatcherActions::setupWatcherActionsDeserializer);

    private WatcherActions(Builder builder) {
        this.actions = ApiTypeHelper.unmodifiableRequired(builder.actions, (Object)this, "actions");
    }

    public static WatcherActions of(Function<Builder, ObjectBuilder<WatcherActions>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, WatcherActionTotals> actions() {
        return this.actions;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.actions)) {
            generator.writeKey("actions");
            generator.writeStartObject();
            for (Map.Entry<String, WatcherActionTotals> item0 : this.actions.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupWatcherActionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actions, JsonpDeserializer.stringMapDeserializer(WatcherActionTotals._DESERIALIZER), "actions");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<WatcherActions> {
        private Map<String, WatcherActionTotals> actions;

        public Builder() {
        }

        private Builder(WatcherActions instance) {
            this.actions = instance.actions;
        }

        public final Builder actions(Map<String, WatcherActionTotals> map) {
            this.actions = Builder._mapPutAll(this.actions, map);
            return this;
        }

        public final Builder actions(String key, WatcherActionTotals value) {
            this.actions = Builder._mapPut(this.actions, key, value);
            return this;
        }

        public final Builder actions(String key, Function<WatcherActionTotals.Builder, ObjectBuilder<WatcherActionTotals>> fn) {
            return this.actions(key, fn.apply(new WatcherActionTotals.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public WatcherActions build() {
            this._checkSingleUse();
            return new WatcherActions(this);
        }
    }
}

