/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SecurityRolesFile
implements JsonpSerializable {
    private final boolean dls;
    private final boolean fls;
    private final long size;
    public static final JsonpDeserializer<SecurityRolesFile> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SecurityRolesFile::setupSecurityRolesFileDeserializer);

    private SecurityRolesFile(Builder builder) {
        this.dls = ApiTypeHelper.requireNonNull(builder.dls, (Object)this, "dls", false);
        this.fls = ApiTypeHelper.requireNonNull(builder.fls, (Object)this, "fls", false);
        this.size = ApiTypeHelper.requireNonNull(builder.size, (Object)this, "size", 0L);
    }

    public static SecurityRolesFile of(Function<Builder, ObjectBuilder<SecurityRolesFile>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean dls() {
        return this.dls;
    }

    public final boolean fls() {
        return this.fls;
    }

    public final long size() {
        return this.size;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("dls");
        generator.write(this.dls);
        generator.writeKey("fls");
        generator.write(this.fls);
        generator.writeKey("size");
        generator.write(this.size);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSecurityRolesFileDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::dls, JsonpDeserializer.booleanDeserializer(), "dls");
        op.add(Builder::fls, JsonpDeserializer.booleanDeserializer(), "fls");
        op.add(Builder::size, JsonpDeserializer.longDeserializer(), "size");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SecurityRolesFile> {
        private Boolean dls;
        private Boolean fls;
        private Long size;

        public Builder() {
        }

        private Builder(SecurityRolesFile instance) {
            this.dls = instance.dls;
            this.fls = instance.fls;
            this.size = instance.size;
        }

        public final Builder dls(boolean value) {
            this.dls = value;
            return this;
        }

        public final Builder fls(boolean value) {
            this.fls = value;
            return this;
        }

        public final Builder size(long value) {
            this.size = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SecurityRolesFile build() {
            this._checkSingleUse();
            return new SecurityRolesFile(this);
        }
    }
}

