/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.RealmCache;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Realm
extends Base {
    private final List<String> name;
    private final List<Long> order;
    private final List<Long> size;
    private final List<RealmCache> cache;
    private final List<Boolean> hasAuthorizationRealms;
    private final List<Boolean> hasDefaultUsernamePattern;
    private final List<Boolean> hasTruststore;
    private final List<Boolean> isAuthenticationDelegated;
    public static final JsonpDeserializer<Realm> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Realm::setupRealmDeserializer);

    private Realm(Builder builder) {
        super(builder);
        this.name = ApiTypeHelper.unmodifiable(builder.name);
        this.order = ApiTypeHelper.unmodifiable(builder.order);
        this.size = ApiTypeHelper.unmodifiable(builder.size);
        this.cache = ApiTypeHelper.unmodifiable(builder.cache);
        this.hasAuthorizationRealms = ApiTypeHelper.unmodifiable(builder.hasAuthorizationRealms);
        this.hasDefaultUsernamePattern = ApiTypeHelper.unmodifiable(builder.hasDefaultUsernamePattern);
        this.hasTruststore = ApiTypeHelper.unmodifiable(builder.hasTruststore);
        this.isAuthenticationDelegated = ApiTypeHelper.unmodifiable(builder.isAuthenticationDelegated);
    }

    public static Realm of(Function<Builder, ObjectBuilder<Realm>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> name() {
        return this.name;
    }

    public final List<Long> order() {
        return this.order;
    }

    public final List<Long> size() {
        return this.size;
    }

    public final List<RealmCache> cache() {
        return this.cache;
    }

    public final List<Boolean> hasAuthorizationRealms() {
        return this.hasAuthorizationRealms;
    }

    public final List<Boolean> hasDefaultUsernamePattern() {
        return this.hasDefaultUsernamePattern;
    }

    public final List<Boolean> hasTruststore() {
        return this.hasTruststore;
    }

    public final List<Boolean> isAuthenticationDelegated() {
        return this.isAuthenticationDelegated;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.name)) {
            generator.writeKey("name");
            generator.writeStartArray();
            for (String string : this.name) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.order)) {
            generator.writeKey("order");
            generator.writeStartArray();
            for (Long l : this.order) {
                generator.write(l.longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.size)) {
            generator.writeKey("size");
            generator.writeStartArray();
            for (Long l : this.size) {
                generator.write(l.longValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.cache)) {
            generator.writeKey("cache");
            generator.writeStartArray();
            for (RealmCache realmCache : this.cache) {
                realmCache.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.hasAuthorizationRealms)) {
            generator.writeKey("has_authorization_realms");
            generator.writeStartArray();
            for (Boolean bl : this.hasAuthorizationRealms) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.hasDefaultUsernamePattern)) {
            generator.writeKey("has_default_username_pattern");
            generator.writeStartArray();
            for (Boolean bl : this.hasDefaultUsernamePattern) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.hasTruststore)) {
            generator.writeKey("has_truststore");
            generator.writeStartArray();
            for (Boolean bl : this.hasTruststore) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.isAuthenticationDelegated)) {
            generator.writeKey("is_authentication_delegated");
            generator.writeStartArray();
            for (Boolean bl : this.isAuthenticationDelegated) {
                generator.write(bl.booleanValue());
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupRealmDeserializer(ObjectDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::name, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "name");
        op.add(Builder::order, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.longDeserializer()), "order");
        op.add(Builder::size, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.longDeserializer()), "size");
        op.add(Builder::cache, JsonpDeserializer.arrayDeserializer(RealmCache._DESERIALIZER), "cache");
        op.add(Builder::hasAuthorizationRealms, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_authorization_realms");
        op.add(Builder::hasDefaultUsernamePattern, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_default_username_pattern");
        op.add(Builder::hasTruststore, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "has_truststore");
        op.add(Builder::isAuthenticationDelegated, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.booleanDeserializer()), "is_authentication_delegated");
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<Realm> {
        @Nullable
        private List<String> name;
        @Nullable
        private List<Long> order;
        @Nullable
        private List<Long> size;
        @Nullable
        private List<RealmCache> cache;
        @Nullable
        private List<Boolean> hasAuthorizationRealms;
        @Nullable
        private List<Boolean> hasDefaultUsernamePattern;
        @Nullable
        private List<Boolean> hasTruststore;
        @Nullable
        private List<Boolean> isAuthenticationDelegated;

        public Builder() {
        }

        private Builder(Realm instance) {
            this.name = instance.name;
            this.order = instance.order;
            this.size = instance.size;
            this.cache = instance.cache;
            this.hasAuthorizationRealms = instance.hasAuthorizationRealms;
            this.hasDefaultUsernamePattern = instance.hasDefaultUsernamePattern;
            this.hasTruststore = instance.hasTruststore;
            this.isAuthenticationDelegated = instance.isAuthenticationDelegated;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        public final Builder order(List<Long> list) {
            this.order = Builder._listAddAll(this.order, list);
            return this;
        }

        public final Builder order(Long value, Long ... values) {
            this.order = Builder._listAdd(this.order, value, values);
            return this;
        }

        public final Builder size(List<Long> list) {
            this.size = Builder._listAddAll(this.size, list);
            return this;
        }

        public final Builder size(Long value, Long ... values) {
            this.size = Builder._listAdd(this.size, value, values);
            return this;
        }

        public final Builder cache(List<RealmCache> list) {
            this.cache = Builder._listAddAll(this.cache, list);
            return this;
        }

        public final Builder cache(RealmCache value, RealmCache ... values) {
            this.cache = Builder._listAdd(this.cache, value, values);
            return this;
        }

        public final Builder cache(Function<RealmCache.Builder, ObjectBuilder<RealmCache>> fn) {
            return this.cache(fn.apply(new RealmCache.Builder()).build(), new RealmCache[0]);
        }

        public final Builder hasAuthorizationRealms(List<Boolean> list) {
            this.hasAuthorizationRealms = Builder._listAddAll(this.hasAuthorizationRealms, list);
            return this;
        }

        public final Builder hasAuthorizationRealms(Boolean value, Boolean ... values) {
            this.hasAuthorizationRealms = Builder._listAdd(this.hasAuthorizationRealms, value, values);
            return this;
        }

        public final Builder hasDefaultUsernamePattern(List<Boolean> list) {
            this.hasDefaultUsernamePattern = Builder._listAddAll(this.hasDefaultUsernamePattern, list);
            return this;
        }

        public final Builder hasDefaultUsernamePattern(Boolean value, Boolean ... values) {
            this.hasDefaultUsernamePattern = Builder._listAdd(this.hasDefaultUsernamePattern, value, values);
            return this;
        }

        public final Builder hasTruststore(List<Boolean> list) {
            this.hasTruststore = Builder._listAddAll(this.hasTruststore, list);
            return this;
        }

        public final Builder hasTruststore(Boolean value, Boolean ... values) {
            this.hasTruststore = Builder._listAdd(this.hasTruststore, value, values);
            return this;
        }

        public final Builder isAuthenticationDelegated(List<Boolean> list) {
            this.isAuthenticationDelegated = Builder._listAddAll(this.isAuthenticationDelegated, list);
            return this;
        }

        public final Builder isAuthenticationDelegated(Boolean value, Boolean ... values) {
            this.isAuthenticationDelegated = Builder._listAdd(this.isAuthenticationDelegated, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Realm build() {
            this._checkSingleUse();
            return new Realm(this);
        }
    }
}

