/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.xpack.usage.MlCounter;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceIngestProcessorCount;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class MlInferenceIngestProcessor
implements JsonpSerializable {
    private final MlInferenceIngestProcessorCount numDocsProcessed;
    private final MlCounter pipelines;
    private final MlInferenceIngestProcessorCount numFailures;
    private final MlInferenceIngestProcessorCount timeMs;
    public static final JsonpDeserializer<MlInferenceIngestProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInferenceIngestProcessor::setupMlInferenceIngestProcessorDeserializer);

    private MlInferenceIngestProcessor(Builder builder) {
        this.numDocsProcessed = ApiTypeHelper.requireNonNull(builder.numDocsProcessed, this, "numDocsProcessed");
        this.pipelines = ApiTypeHelper.requireNonNull(builder.pipelines, this, "pipelines");
        this.numFailures = ApiTypeHelper.requireNonNull(builder.numFailures, this, "numFailures");
        this.timeMs = ApiTypeHelper.requireNonNull(builder.timeMs, this, "timeMs");
    }

    public static MlInferenceIngestProcessor of(Function<Builder, ObjectBuilder<MlInferenceIngestProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final MlInferenceIngestProcessorCount numDocsProcessed() {
        return this.numDocsProcessed;
    }

    public final MlCounter pipelines() {
        return this.pipelines;
    }

    public final MlInferenceIngestProcessorCount numFailures() {
        return this.numFailures;
    }

    public final MlInferenceIngestProcessorCount timeMs() {
        return this.timeMs;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_docs_processed");
        this.numDocsProcessed.serialize(generator, mapper);
        generator.writeKey("pipelines");
        this.pipelines.serialize(generator, mapper);
        generator.writeKey("num_failures");
        this.numFailures.serialize(generator, mapper);
        generator.writeKey("time_ms");
        this.timeMs.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMlInferenceIngestProcessorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numDocsProcessed, MlInferenceIngestProcessorCount._DESERIALIZER, "num_docs_processed");
        op.add(Builder::pipelines, MlCounter._DESERIALIZER, "pipelines");
        op.add(Builder::numFailures, MlInferenceIngestProcessorCount._DESERIALIZER, "num_failures");
        op.add(Builder::timeMs, MlInferenceIngestProcessorCount._DESERIALIZER, "time_ms");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MlInferenceIngestProcessor> {
        private MlInferenceIngestProcessorCount numDocsProcessed;
        private MlCounter pipelines;
        private MlInferenceIngestProcessorCount numFailures;
        private MlInferenceIngestProcessorCount timeMs;

        public Builder() {
        }

        private Builder(MlInferenceIngestProcessor instance) {
            this.numDocsProcessed = instance.numDocsProcessed;
            this.pipelines = instance.pipelines;
            this.numFailures = instance.numFailures;
            this.timeMs = instance.timeMs;
        }

        public final Builder numDocsProcessed(MlInferenceIngestProcessorCount value) {
            this.numDocsProcessed = value;
            return this;
        }

        public final Builder numDocsProcessed(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.numDocsProcessed(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        public final Builder pipelines(MlCounter value) {
            this.pipelines = value;
            return this;
        }

        public final Builder pipelines(Function<MlCounter.Builder, ObjectBuilder<MlCounter>> fn) {
            return this.pipelines(fn.apply(new MlCounter.Builder()).build());
        }

        public final Builder numFailures(MlInferenceIngestProcessorCount value) {
            this.numFailures = value;
            return this;
        }

        public final Builder numFailures(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.numFailures(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        public final Builder timeMs(MlInferenceIngestProcessorCount value) {
            this.timeMs = value;
            return this;
        }

        public final Builder timeMs(Function<MlInferenceIngestProcessorCount.Builder, ObjectBuilder<MlInferenceIngestProcessorCount>> fn) {
            return this.timeMs(fn.apply(new MlInferenceIngestProcessorCount.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MlInferenceIngestProcessor build() {
            this._checkSingleUse();
            return new MlInferenceIngestProcessor(this);
        }
    }
}

