/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.SlackAttachment;
import co.elastic.clients.elasticsearch.watcher.SlackDynamicAttachment;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlackMessage
implements JsonpSerializable {
    private final List<SlackAttachment> attachments;
    @Nullable
    private final SlackDynamicAttachment dynamicAttachments;
    private final String from;
    @Nullable
    private final String icon;
    private final String text;
    private final List<String> to;
    public static final JsonpDeserializer<SlackMessage> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlackMessage::setupSlackMessageDeserializer);

    private SlackMessage(Builder builder) {
        this.attachments = ApiTypeHelper.unmodifiableRequired(builder.attachments, (Object)this, "attachments");
        this.dynamicAttachments = builder.dynamicAttachments;
        this.from = ApiTypeHelper.requireNonNull(builder.from, this, "from");
        this.icon = builder.icon;
        this.text = ApiTypeHelper.requireNonNull(builder.text, this, "text");
        this.to = ApiTypeHelper.unmodifiableRequired(builder.to, (Object)this, "to");
    }

    public static SlackMessage of(Function<Builder, ObjectBuilder<SlackMessage>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<SlackAttachment> attachments() {
        return this.attachments;
    }

    @Nullable
    public final SlackDynamicAttachment dynamicAttachments() {
        return this.dynamicAttachments;
    }

    public final String from() {
        return this.from;
    }

    @Nullable
    public final String icon() {
        return this.icon;
    }

    public final String text() {
        return this.text;
    }

    public final List<String> to() {
        return this.to;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.attachments)) {
            generator.writeKey("attachments");
            generator.writeStartArray();
            for (SlackAttachment slackAttachment : this.attachments) {
                slackAttachment.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.dynamicAttachments != null) {
            generator.writeKey("dynamic_attachments");
            this.dynamicAttachments.serialize(generator, mapper);
        }
        generator.writeKey("from");
        generator.write(this.from);
        if (this.icon != null) {
            generator.writeKey("icon");
            generator.write(this.icon);
        }
        generator.writeKey("text");
        generator.write(this.text);
        if (ApiTypeHelper.isDefined(this.to)) {
            generator.writeKey("to");
            generator.writeStartArray();
            for (String string : this.to) {
                generator.write(string);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSlackMessageDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::attachments, JsonpDeserializer.arrayDeserializer(SlackAttachment._DESERIALIZER), "attachments");
        op.add(Builder::dynamicAttachments, SlackDynamicAttachment._DESERIALIZER, "dynamic_attachments");
        op.add(Builder::from, JsonpDeserializer.stringDeserializer(), "from");
        op.add(Builder::icon, JsonpDeserializer.stringDeserializer(), "icon");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
        op.add(Builder::to, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "to");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlackMessage> {
        private List<SlackAttachment> attachments;
        @Nullable
        private SlackDynamicAttachment dynamicAttachments;
        private String from;
        @Nullable
        private String icon;
        private String text;
        private List<String> to;

        public Builder() {
        }

        private Builder(SlackMessage instance) {
            this.attachments = instance.attachments;
            this.dynamicAttachments = instance.dynamicAttachments;
            this.from = instance.from;
            this.icon = instance.icon;
            this.text = instance.text;
            this.to = instance.to;
        }

        public final Builder attachments(List<SlackAttachment> list) {
            this.attachments = Builder._listAddAll(this.attachments, list);
            return this;
        }

        public final Builder attachments(SlackAttachment value, SlackAttachment ... values) {
            this.attachments = Builder._listAdd(this.attachments, value, values);
            return this;
        }

        public final Builder attachments(Function<SlackAttachment.Builder, ObjectBuilder<SlackAttachment>> fn) {
            return this.attachments(fn.apply(new SlackAttachment.Builder()).build(), new SlackAttachment[0]);
        }

        public final Builder dynamicAttachments(@Nullable SlackDynamicAttachment value) {
            this.dynamicAttachments = value;
            return this;
        }

        public final Builder dynamicAttachments(Function<SlackDynamicAttachment.Builder, ObjectBuilder<SlackDynamicAttachment>> fn) {
            return this.dynamicAttachments(fn.apply(new SlackDynamicAttachment.Builder()).build());
        }

        public final Builder from(String value) {
            this.from = value;
            return this;
        }

        public final Builder icon(@Nullable String value) {
            this.icon = value;
            return this;
        }

        public final Builder text(String value) {
            this.text = value;
            return this;
        }

        public final Builder to(List<String> list) {
            this.to = Builder._listAddAll(this.to, list);
            return this;
        }

        public final Builder to(String value, String ... values) {
            this.to = Builder._listAdd(this.to, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlackMessage build() {
            this._checkSingleUse();
            return new SlackMessage(this);
        }
    }
}

