/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.AcknowledgementOptions;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class AcknowledgeState
implements JsonpSerializable {
    private final AcknowledgementOptions state;
    private final DateTime timestamp;
    public static final JsonpDeserializer<AcknowledgeState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AcknowledgeState::setupAcknowledgeStateDeserializer);

    private AcknowledgeState(Builder builder) {
        this.state = ApiTypeHelper.requireNonNull(builder.state, this, "state");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static AcknowledgeState of(Function<Builder, ObjectBuilder<AcknowledgeState>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final AcknowledgementOptions state() {
        return this.state;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAcknowledgeStateDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::state, AcknowledgementOptions._DESERIALIZER, "state");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AcknowledgeState> {
        private AcknowledgementOptions state;
        private DateTime timestamp;

        public Builder() {
        }

        private Builder(AcknowledgeState instance) {
            this.state = instance.state;
            this.timestamp = instance.timestamp;
        }

        public final Builder state(AcknowledgementOptions value) {
            this.state = value;
            return this;
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AcknowledgeState build() {
            this._checkSingleUse();
            return new AcknowledgeState(this);
        }
    }
}

