/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.text_structure.TestGrokPatternResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TestGrokPatternRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String ecsCompatibility;
    private final String grokPattern;
    private final List<String> text;
    public static final JsonpDeserializer<TestGrokPatternRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TestGrokPatternRequest::setupTestGrokPatternRequestDeserializer);
    public static final Endpoint<TestGrokPatternRequest, TestGrokPatternResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TestGrokPatternRequest, TestGrokPatternResponse>("es/text_structure.test_grok_pattern", request -> "POST", request -> "/_text_structure/test_grok_pattern", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ecsCompatibility != null) {
            params.put("ecs_compatibility", request.ecsCompatibility);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, TestGrokPatternResponse._DESERIALIZER);

    private TestGrokPatternRequest(Builder builder) {
        this.ecsCompatibility = builder.ecsCompatibility;
        this.grokPattern = ApiTypeHelper.requireNonNull(builder.grokPattern, this, "grokPattern");
        this.text = ApiTypeHelper.unmodifiableRequired(builder.text, (Object)this, "text");
    }

    public static TestGrokPatternRequest of(Function<Builder, ObjectBuilder<TestGrokPatternRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String ecsCompatibility() {
        return this.ecsCompatibility;
    }

    public final String grokPattern() {
        return this.grokPattern;
    }

    public final List<String> text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("grok_pattern");
        generator.write(this.grokPattern);
        if (ApiTypeHelper.isDefined(this.text)) {
            generator.writeKey("text");
            generator.writeStartArray();
            for (String item0 : this.text) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTestGrokPatternRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::grokPattern, JsonpDeserializer.stringDeserializer(), "grok_pattern");
        op.add(Builder::text, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "text");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<TestGrokPatternRequest> {
        @Nullable
        private String ecsCompatibility;
        private String grokPattern;
        private List<String> text;

        public Builder() {
        }

        private Builder(TestGrokPatternRequest instance) {
            this.ecsCompatibility = instance.ecsCompatibility;
            this.grokPattern = instance.grokPattern;
            this.text = instance.text;
        }

        public final Builder ecsCompatibility(@Nullable String value) {
            this.ecsCompatibility = value;
            return this;
        }

        public final Builder grokPattern(String value) {
            this.grokPattern = value;
            return this;
        }

        public final Builder text(List<String> list) {
            this.text = Builder._listAddAll(this.text, list);
            return this;
        }

        public final Builder text(String value, String ... values) {
            this.text = Builder._listAdd(this.text, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TestGrokPatternRequest build() {
            this._checkSingleUse();
            return new TestGrokPatternRequest(this);
        }
    }
}

