/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch.snapshot.ShardsStats;
import co.elastic.clients.elasticsearch.snapshot.SnapshotShardsStatus;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotIndexStats
implements JsonpSerializable {
    private final Map<String, SnapshotShardsStatus> shards;
    private final ShardsStats shardsStats;
    private final SnapshotStats stats;
    public static final JsonpDeserializer<SnapshotIndexStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotIndexStats::setupSnapshotIndexStatsDeserializer);

    private SnapshotIndexStats(Builder builder) {
        this.shards = ApiTypeHelper.unmodifiableRequired(builder.shards, (Object)this, "shards");
        this.shardsStats = ApiTypeHelper.requireNonNull(builder.shardsStats, this, "shardsStats");
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
    }

    public static SnapshotIndexStats of(Function<Builder, ObjectBuilder<SnapshotIndexStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, SnapshotShardsStatus> shards() {
        return this.shards;
    }

    public final ShardsStats shardsStats() {
        return this.shardsStats;
    }

    public final SnapshotStats stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, SnapshotShardsStatus> item0 : this.shards.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("shards_stats");
        this.shardsStats.serialize(generator, mapper);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSnapshotIndexStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(SnapshotShardsStatus._DESERIALIZER), "shards");
        op.add(Builder::shardsStats, ShardsStats._DESERIALIZER, "shards_stats");
        op.add(Builder::stats, SnapshotStats._DESERIALIZER, "stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotIndexStats> {
        private Map<String, SnapshotShardsStatus> shards;
        private ShardsStats shardsStats;
        private SnapshotStats stats;

        public Builder() {
        }

        private Builder(SnapshotIndexStats instance) {
            this.shards = instance.shards;
            this.shardsStats = instance.shardsStats;
            this.stats = instance.stats;
        }

        public final Builder shards(Map<String, SnapshotShardsStatus> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        public final Builder shards(String key, SnapshotShardsStatus value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        public final Builder shards(String key, Function<SnapshotShardsStatus.Builder, ObjectBuilder<SnapshotShardsStatus>> fn) {
            return this.shards(key, fn.apply(new SnapshotShardsStatus.Builder()).build());
        }

        public final Builder shardsStats(ShardsStats value) {
            this.shardsStats = value;
            return this;
        }

        public final Builder shardsStats(Function<ShardsStats.Builder, ObjectBuilder<ShardsStats>> fn) {
            return this.shardsStats(fn.apply(new ShardsStats.Builder()).build());
        }

        public final Builder stats(SnapshotStats value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<SnapshotStats.Builder, ObjectBuilder<SnapshotStats>> fn) {
            return this.stats(fn.apply(new SnapshotStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotIndexStats build() {
            this._checkSingleUse();
            return new SnapshotIndexStats(this);
        }
    }
}

