/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ShardsStats
implements JsonpSerializable {
    private final long done;
    private final long failed;
    private final long finalizing;
    private final long initializing;
    private final long started;
    private final long total;
    public static final JsonpDeserializer<ShardsStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsStats::setupShardsStatsDeserializer);

    private ShardsStats(Builder builder) {
        this.done = ApiTypeHelper.requireNonNull(builder.done, (Object)this, "done", 0L);
        this.failed = ApiTypeHelper.requireNonNull(builder.failed, (Object)this, "failed", 0L);
        this.finalizing = ApiTypeHelper.requireNonNull(builder.finalizing, (Object)this, "finalizing", 0L);
        this.initializing = ApiTypeHelper.requireNonNull(builder.initializing, (Object)this, "initializing", 0L);
        this.started = ApiTypeHelper.requireNonNull(builder.started, (Object)this, "started", 0L);
        this.total = ApiTypeHelper.requireNonNull(builder.total, (Object)this, "total", 0L);
    }

    public static ShardsStats of(Function<Builder, ObjectBuilder<ShardsStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long done() {
        return this.done;
    }

    public final long failed() {
        return this.failed;
    }

    public final long finalizing() {
        return this.finalizing;
    }

    public final long initializing() {
        return this.initializing;
    }

    public final long started() {
        return this.started;
    }

    public final long total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("done");
        generator.write(this.done);
        generator.writeKey("failed");
        generator.write(this.failed);
        generator.writeKey("finalizing");
        generator.write(this.finalizing);
        generator.writeKey("initializing");
        generator.write(this.initializing);
        generator.writeKey("started");
        generator.write(this.started);
        generator.writeKey("total");
        generator.write(this.total);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupShardsStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::done, JsonpDeserializer.longDeserializer(), "done");
        op.add(Builder::failed, JsonpDeserializer.longDeserializer(), "failed");
        op.add(Builder::finalizing, JsonpDeserializer.longDeserializer(), "finalizing");
        op.add(Builder::initializing, JsonpDeserializer.longDeserializer(), "initializing");
        op.add(Builder::started, JsonpDeserializer.longDeserializer(), "started");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ShardsStats> {
        private Long done;
        private Long failed;
        private Long finalizing;
        private Long initializing;
        private Long started;
        private Long total;

        public Builder() {
        }

        private Builder(ShardsStats instance) {
            this.done = instance.done;
            this.failed = instance.failed;
            this.finalizing = instance.finalizing;
            this.initializing = instance.initializing;
            this.started = instance.started;
            this.total = instance.total;
        }

        public final Builder done(long value) {
            this.done = value;
            return this;
        }

        public final Builder failed(long value) {
            this.failed = value;
            return this;
        }

        public final Builder finalizing(long value) {
            this.finalizing = value;
            return this;
        }

        public final Builder initializing(long value) {
            this.initializing = value;
            return this;
        }

        public final Builder started(long value) {
            this.started = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShardsStats build() {
            this._checkSingleUse();
            return new ShardsStats(this);
        }
    }
}

