/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.slm;

import co.elastic.clients.elasticsearch.slm.InProgress;
import co.elastic.clients.elasticsearch.slm.Invocation;
import co.elastic.clients.elasticsearch.slm.SlmPolicy;
import co.elastic.clients.elasticsearch.slm.Statistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SnapshotLifecycle
implements JsonpSerializable {
    @Nullable
    private final InProgress inProgress;
    @Nullable
    private final Invocation lastFailure;
    @Nullable
    private final Invocation lastSuccess;
    @Nullable
    private final DateTime modifiedDate;
    private final long modifiedDateMillis;
    @Nullable
    private final DateTime nextExecution;
    private final long nextExecutionMillis;
    private final SlmPolicy policy;
    private final long version;
    private final Statistics stats;
    public static final JsonpDeserializer<SnapshotLifecycle> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotLifecycle::setupSnapshotLifecycleDeserializer);

    private SnapshotLifecycle(Builder builder) {
        this.inProgress = builder.inProgress;
        this.lastFailure = builder.lastFailure;
        this.lastSuccess = builder.lastSuccess;
        this.modifiedDate = builder.modifiedDate;
        this.modifiedDateMillis = ApiTypeHelper.requireNonNull(builder.modifiedDateMillis, (Object)this, "modifiedDateMillis", 0L);
        this.nextExecution = builder.nextExecution;
        this.nextExecutionMillis = ApiTypeHelper.requireNonNull(builder.nextExecutionMillis, (Object)this, "nextExecutionMillis", 0L);
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.version = ApiTypeHelper.requireNonNull(builder.version, (Object)this, "version", 0L);
        this.stats = ApiTypeHelper.requireNonNull(builder.stats, this, "stats");
    }

    public static SnapshotLifecycle of(Function<Builder, ObjectBuilder<SnapshotLifecycle>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final InProgress inProgress() {
        return this.inProgress;
    }

    @Nullable
    public final Invocation lastFailure() {
        return this.lastFailure;
    }

    @Nullable
    public final Invocation lastSuccess() {
        return this.lastSuccess;
    }

    @Nullable
    public final DateTime modifiedDate() {
        return this.modifiedDate;
    }

    public final long modifiedDateMillis() {
        return this.modifiedDateMillis;
    }

    @Nullable
    public final DateTime nextExecution() {
        return this.nextExecution;
    }

    public final long nextExecutionMillis() {
        return this.nextExecutionMillis;
    }

    public final SlmPolicy policy() {
        return this.policy;
    }

    public final long version() {
        return this.version;
    }

    public final Statistics stats() {
        return this.stats;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.inProgress != null) {
            generator.writeKey("in_progress");
            this.inProgress.serialize(generator, mapper);
        }
        if (this.lastFailure != null) {
            generator.writeKey("last_failure");
            this.lastFailure.serialize(generator, mapper);
        }
        if (this.lastSuccess != null) {
            generator.writeKey("last_success");
            this.lastSuccess.serialize(generator, mapper);
        }
        if (this.modifiedDate != null) {
            generator.writeKey("modified_date");
            this.modifiedDate.serialize(generator, mapper);
        }
        generator.writeKey("modified_date_millis");
        generator.write(this.modifiedDateMillis);
        if (this.nextExecution != null) {
            generator.writeKey("next_execution");
            this.nextExecution.serialize(generator, mapper);
        }
        generator.writeKey("next_execution_millis");
        generator.write(this.nextExecutionMillis);
        generator.writeKey("policy");
        this.policy.serialize(generator, mapper);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("stats");
        this.stats.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSnapshotLifecycleDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::inProgress, InProgress._DESERIALIZER, "in_progress");
        op.add(Builder::lastFailure, Invocation._DESERIALIZER, "last_failure");
        op.add(Builder::lastSuccess, Invocation._DESERIALIZER, "last_success");
        op.add(Builder::modifiedDate, DateTime._DESERIALIZER, "modified_date");
        op.add(Builder::modifiedDateMillis, JsonpDeserializer.longDeserializer(), "modified_date_millis");
        op.add(Builder::nextExecution, DateTime._DESERIALIZER, "next_execution");
        op.add(Builder::nextExecutionMillis, JsonpDeserializer.longDeserializer(), "next_execution_millis");
        op.add(Builder::policy, SlmPolicy._DESERIALIZER, "policy");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::stats, Statistics._DESERIALIZER, "stats");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotLifecycle> {
        @Nullable
        private InProgress inProgress;
        @Nullable
        private Invocation lastFailure;
        @Nullable
        private Invocation lastSuccess;
        @Nullable
        private DateTime modifiedDate;
        private Long modifiedDateMillis;
        @Nullable
        private DateTime nextExecution;
        private Long nextExecutionMillis;
        private SlmPolicy policy;
        private Long version;
        private Statistics stats;

        public Builder() {
        }

        private Builder(SnapshotLifecycle instance) {
            this.inProgress = instance.inProgress;
            this.lastFailure = instance.lastFailure;
            this.lastSuccess = instance.lastSuccess;
            this.modifiedDate = instance.modifiedDate;
            this.modifiedDateMillis = instance.modifiedDateMillis;
            this.nextExecution = instance.nextExecution;
            this.nextExecutionMillis = instance.nextExecutionMillis;
            this.policy = instance.policy;
            this.version = instance.version;
            this.stats = instance.stats;
        }

        public final Builder inProgress(@Nullable InProgress value) {
            this.inProgress = value;
            return this;
        }

        public final Builder inProgress(Function<InProgress.Builder, ObjectBuilder<InProgress>> fn) {
            return this.inProgress(fn.apply(new InProgress.Builder()).build());
        }

        public final Builder lastFailure(@Nullable Invocation value) {
            this.lastFailure = value;
            return this;
        }

        public final Builder lastFailure(Function<Invocation.Builder, ObjectBuilder<Invocation>> fn) {
            return this.lastFailure(fn.apply(new Invocation.Builder()).build());
        }

        public final Builder lastSuccess(@Nullable Invocation value) {
            this.lastSuccess = value;
            return this;
        }

        public final Builder lastSuccess(Function<Invocation.Builder, ObjectBuilder<Invocation>> fn) {
            return this.lastSuccess(fn.apply(new Invocation.Builder()).build());
        }

        public final Builder modifiedDate(@Nullable DateTime value) {
            this.modifiedDate = value;
            return this;
        }

        public final Builder modifiedDateMillis(long value) {
            this.modifiedDateMillis = value;
            return this;
        }

        public final Builder nextExecution(@Nullable DateTime value) {
            this.nextExecution = value;
            return this;
        }

        public final Builder nextExecutionMillis(long value) {
            this.nextExecutionMillis = value;
            return this;
        }

        public final Builder policy(SlmPolicy value) {
            this.policy = value;
            return this;
        }

        public final Builder policy(Function<SlmPolicy.Builder, ObjectBuilder<SlmPolicy>> fn) {
            return this.policy(fn.apply(new SlmPolicy.Builder()).build());
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder stats(Statistics value) {
            this.stats = value;
            return this;
        }

        public final Builder stats(Function<Statistics.Builder, ObjectBuilder<Statistics>> fn) {
            return this.stats(fn.apply(new Statistics.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotLifecycle build() {
            this._checkSingleUse();
            return new SnapshotLifecycle(this);
        }
    }
}

