/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.security.Access;
import co.elastic.clients.elasticsearch.security.UpdateCrossClusterApiKeyResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class UpdateCrossClusterApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    private final Access access;
    @Nullable
    private final Time expiration;
    private final String id;
    private final Map<String, JsonData> metadata;
    public static final JsonpDeserializer<UpdateCrossClusterApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateCrossClusterApiKeyRequest::setupUpdateCrossClusterApiKeyRequestDeserializer);
    public static final Endpoint<UpdateCrossClusterApiKeyRequest, UpdateCrossClusterApiKeyResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<UpdateCrossClusterApiKeyRequest, UpdateCrossClusterApiKeyResponse>("es/security.update_cross_cluster_api_key", request -> "PUT", request -> {
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/cross_cluster");
            buf.append("/api_key");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.id, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _id = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("id", request.id);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateCrossClusterApiKeyResponse._DESERIALIZER);

    private UpdateCrossClusterApiKeyRequest(Builder builder) {
        this.access = ApiTypeHelper.requireNonNull(builder.access, this, "access");
        this.expiration = builder.expiration;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
    }

    public static UpdateCrossClusterApiKeyRequest of(Function<Builder, ObjectBuilder<UpdateCrossClusterApiKeyRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Access access() {
        return this.access;
    }

    @Nullable
    public final Time expiration() {
        return this.expiration;
    }

    public final String id() {
        return this.id;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("access");
        this.access.serialize(generator, mapper);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            this.expiration.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupUpdateCrossClusterApiKeyRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::access, Access._DESERIALIZER, "access");
        op.add(Builder::expiration, Time._DESERIALIZER, "expiration");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UpdateCrossClusterApiKeyRequest> {
        private Access access;
        @Nullable
        private Time expiration;
        private String id;
        @Nullable
        private Map<String, JsonData> metadata;

        public Builder() {
        }

        private Builder(UpdateCrossClusterApiKeyRequest instance) {
            this.access = instance.access;
            this.expiration = instance.expiration;
            this.id = instance.id;
            this.metadata = instance.metadata;
        }

        public final Builder access(Access value) {
            this.access = value;
            return this;
        }

        public final Builder access(Function<Access.Builder, ObjectBuilder<Access>> fn) {
            return this.access(fn.apply(new Access.Builder()).build());
        }

        public final Builder expiration(@Nullable Time value) {
            this.expiration = value;
            return this;
        }

        public final Builder expiration(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.expiration(fn.apply(new Time.Builder()).build());
        }

        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UpdateCrossClusterApiKeyRequest build() {
            this._checkSingleUse();
            return new UpdateCrossClusterApiKeyRequest(this);
        }
    }
}

