/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.SamlInvalidateResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SamlInvalidateRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String acs;
    private final String queryString;
    @Nullable
    private final String realm;
    public static final JsonpDeserializer<SamlInvalidateRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SamlInvalidateRequest::setupSamlInvalidateRequestDeserializer);
    public static final Endpoint<SamlInvalidateRequest, SamlInvalidateResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SamlInvalidateRequest, SamlInvalidateResponse>("es/security.saml_invalidate", request -> "POST", request -> "/_security/saml/invalidate", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SamlInvalidateResponse._DESERIALIZER);

    private SamlInvalidateRequest(Builder builder) {
        this.acs = builder.acs;
        this.queryString = ApiTypeHelper.requireNonNull(builder.queryString, this, "queryString");
        this.realm = builder.realm;
    }

    public static SamlInvalidateRequest of(Function<Builder, ObjectBuilder<SamlInvalidateRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String acs() {
        return this.acs;
    }

    public final String queryString() {
        return this.queryString;
    }

    @Nullable
    public final String realm() {
        return this.realm;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.acs != null) {
            generator.writeKey("acs");
            generator.write(this.acs);
        }
        generator.writeKey("query_string");
        generator.write(this.queryString);
        if (this.realm != null) {
            generator.writeKey("realm");
            generator.write(this.realm);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSamlInvalidateRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acs, JsonpDeserializer.stringDeserializer(), "acs");
        op.add(Builder::queryString, JsonpDeserializer.stringDeserializer(), "query_string");
        op.add(Builder::realm, JsonpDeserializer.stringDeserializer(), "realm");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SamlInvalidateRequest> {
        @Nullable
        private String acs;
        private String queryString;
        @Nullable
        private String realm;

        public Builder() {
        }

        private Builder(SamlInvalidateRequest instance) {
            this.acs = instance.acs;
            this.queryString = instance.queryString;
            this.realm = instance.realm;
        }

        public final Builder acs(@Nullable String value) {
            this.acs = value;
            return this;
        }

        public final Builder queryString(String value) {
            this.queryString = value;
            return this;
        }

        public final Builder realm(@Nullable String value) {
            this.realm = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SamlInvalidateRequest build() {
            this._checkSingleUse();
            return new SamlInvalidateRequest(this);
        }
    }
}

