/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.GetPrivilegesResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class GetPrivilegesRequest
extends RequestBase {
    @Nullable
    private final String application;
    private final List<String> name;
    public static final Endpoint<GetPrivilegesRequest, GetPrivilegesResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetPrivilegesRequest, GetPrivilegesResponse>("es/security.get_privileges", request -> "GET", request -> {
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        if (request.application() != null) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/privilege");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.application, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.name.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _application = true;
        int _name = 2;
        int propsSet = 0;
        if (request.application() != null) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.name())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            // empty if block
        }
        if (propsSet == 1) {
            params.put("application", request.application);
        }
        if (propsSet == 3) {
            params.put("application", request.application);
            params.put("name", request.name.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), false, GetPrivilegesResponse._DESERIALIZER);

    private GetPrivilegesRequest(Builder builder) {
        this.application = builder.application;
        this.name = ApiTypeHelper.unmodifiable(builder.name);
    }

    public static GetPrivilegesRequest of(Function<Builder, ObjectBuilder<GetPrivilegesRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String application() {
        return this.application;
    }

    public final List<String> name() {
        return this.name;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetPrivilegesRequest> {
        @Nullable
        private String application;
        @Nullable
        private List<String> name;

        public Builder() {
        }

        private Builder(GetPrivilegesRequest instance) {
            this.application = instance.application;
            this.name = instance.name;
        }

        public final Builder application(@Nullable String value) {
            this.application = value;
            return this;
        }

        public final Builder name(List<String> list) {
            this.name = Builder._listAddAll(this.name, list);
            return this;
        }

        public final Builder name(String value, String ... values) {
            this.name = Builder._listAdd(this.name, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetPrivilegesRequest build() {
            this._checkSingleUse();
            return new GetPrivilegesRequest(this);
        }
    }
}

