/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ActivateUserProfileResponse;
import co.elastic.clients.elasticsearch.security.GrantType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ActivateUserProfileRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String accessToken;
    private final GrantType grantType;
    @Nullable
    private final String password;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<ActivateUserProfileRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ActivateUserProfileRequest::setupActivateUserProfileRequestDeserializer);
    public static final Endpoint<ActivateUserProfileRequest, ActivateUserProfileResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ActivateUserProfileRequest, ActivateUserProfileResponse>("es/security.activate_user_profile", request -> "POST", request -> "/_security/profile/_activate", request -> Collections.emptyMap(), request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ActivateUserProfileResponse._DESERIALIZER);

    private ActivateUserProfileRequest(Builder builder) {
        this.accessToken = builder.accessToken;
        this.grantType = ApiTypeHelper.requireNonNull(builder.grantType, this, "grantType");
        this.password = builder.password;
        this.username = builder.username;
    }

    public static ActivateUserProfileRequest of(Function<Builder, ObjectBuilder<ActivateUserProfileRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String accessToken() {
        return this.accessToken;
    }

    public final GrantType grantType() {
        return this.grantType;
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.accessToken != null) {
            generator.writeKey("access_token");
            generator.write(this.accessToken);
        }
        generator.writeKey("grant_type");
        this.grantType.serialize(generator, mapper);
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupActivateUserProfileRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::accessToken, JsonpDeserializer.stringDeserializer(), "access_token");
        op.add(Builder::grantType, GrantType._DESERIALIZER, "grant_type");
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ActivateUserProfileRequest> {
        @Nullable
        private String accessToken;
        private GrantType grantType;
        @Nullable
        private String password;
        @Nullable
        private String username;

        public Builder() {
        }

        private Builder(ActivateUserProfileRequest instance) {
            this.accessToken = instance.accessToken;
            this.grantType = instance.grantType;
            this.password = instance.password;
            this.username = instance.username;
        }

        public final Builder accessToken(@Nullable String value) {
            this.accessToken = value;
            return this;
        }

        public final Builder grantType(GrantType value) {
            this.grantType = value;
            return this;
        }

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ActivateUserProfileRequest build() {
            this._checkSingleUse();
            return new ActivateUserProfileRequest(this);
        }
    }
}

