/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class NodeProcessInfo
implements JsonpSerializable {
    private final long id;
    private final boolean mlockall;
    private final long refreshIntervalInMillis;
    public static final JsonpDeserializer<NodeProcessInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeProcessInfo::setupNodeProcessInfoDeserializer);

    private NodeProcessInfo(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, (Object)this, "id", 0L);
        this.mlockall = ApiTypeHelper.requireNonNull(builder.mlockall, (Object)this, "mlockall", false);
        this.refreshIntervalInMillis = ApiTypeHelper.requireNonNull(builder.refreshIntervalInMillis, (Object)this, "refreshIntervalInMillis", 0L);
    }

    public static NodeProcessInfo of(Function<Builder, ObjectBuilder<NodeProcessInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long id() {
        return this.id;
    }

    public final boolean mlockall() {
        return this.mlockall;
    }

    public final long refreshIntervalInMillis() {
        return this.refreshIntervalInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        generator.writeKey("mlockall");
        generator.write(this.mlockall);
        generator.writeKey("refresh_interval_in_millis");
        generator.write(this.refreshIntervalInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeProcessInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.longDeserializer(), "id");
        op.add(Builder::mlockall, JsonpDeserializer.booleanDeserializer(), "mlockall");
        op.add(Builder::refreshIntervalInMillis, JsonpDeserializer.longDeserializer(), "refresh_interval_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeProcessInfo> {
        private Long id;
        private Boolean mlockall;
        private Long refreshIntervalInMillis;

        public Builder() {
        }

        private Builder(NodeProcessInfo instance) {
            this.id = instance.id;
            this.mlockall = instance.mlockall;
            this.refreshIntervalInMillis = instance.refreshIntervalInMillis;
        }

        public final Builder id(long value) {
            this.id = value;
            return this;
        }

        public final Builder mlockall(boolean value) {
            this.mlockall = value;
            return this;
        }

        public final Builder refreshIntervalInMillis(long value) {
            this.refreshIntervalInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeProcessInfo build() {
            this._checkSingleUse();
            return new NodeProcessInfo(this);
        }
    }
}

