/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsTransportFeatures;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettingsTransportType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class NodeInfoSettingsTransport
implements JsonpSerializable {
    private final NodeInfoSettingsTransportType type;
    @Nullable
    private final String typeDefault;
    @Nullable
    private final NodeInfoSettingsTransportFeatures features;
    @Nullable
    private final Boolean ignoreDeserializationErrors;
    public static final JsonpDeserializer<NodeInfoSettingsTransport> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfoSettingsTransport::setupNodeInfoSettingsTransportDeserializer);

    private NodeInfoSettingsTransport(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.typeDefault = builder.typeDefault;
        this.features = builder.features;
        this.ignoreDeserializationErrors = builder.ignoreDeserializationErrors;
    }

    public static NodeInfoSettingsTransport of(Function<Builder, ObjectBuilder<NodeInfoSettingsTransport>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final NodeInfoSettingsTransportType type() {
        return this.type;
    }

    @Nullable
    public final String typeDefault() {
        return this.typeDefault;
    }

    @Nullable
    public final NodeInfoSettingsTransportFeatures features() {
        return this.features;
    }

    @Nullable
    public final Boolean ignoreDeserializationErrors() {
        return this.ignoreDeserializationErrors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        this.type.serialize(generator, mapper);
        if (this.typeDefault != null) {
            generator.writeKey("type.default");
            generator.write(this.typeDefault);
        }
        if (this.features != null) {
            generator.writeKey("features");
            this.features.serialize(generator, mapper);
        }
        if (this.ignoreDeserializationErrors != null) {
            generator.writeKey("ignore_deserialization_errors");
            generator.write(this.ignoreDeserializationErrors.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupNodeInfoSettingsTransportDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, NodeInfoSettingsTransportType._DESERIALIZER, "type");
        op.add(Builder::typeDefault, JsonpDeserializer.stringDeserializer(), "type.default");
        op.add(Builder::features, NodeInfoSettingsTransportFeatures._DESERIALIZER, "features");
        op.add(Builder::ignoreDeserializationErrors, JsonpDeserializer.booleanDeserializer(), "ignore_deserialization_errors");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<NodeInfoSettingsTransport> {
        private NodeInfoSettingsTransportType type;
        @Nullable
        private String typeDefault;
        @Nullable
        private NodeInfoSettingsTransportFeatures features;
        @Nullable
        private Boolean ignoreDeserializationErrors;

        public Builder() {
        }

        private Builder(NodeInfoSettingsTransport instance) {
            this.type = instance.type;
            this.typeDefault = instance.typeDefault;
            this.features = instance.features;
            this.ignoreDeserializationErrors = instance.ignoreDeserializationErrors;
        }

        public final Builder type(NodeInfoSettingsTransportType value) {
            this.type = value;
            return this;
        }

        public final Builder type(Function<NodeInfoSettingsTransportType.Builder, ObjectBuilder<NodeInfoSettingsTransportType>> fn) {
            return this.type(fn.apply(new NodeInfoSettingsTransportType.Builder()).build());
        }

        public final Builder typeDefault(@Nullable String value) {
            this.typeDefault = value;
            return this;
        }

        public final Builder features(@Nullable NodeInfoSettingsTransportFeatures value) {
            this.features = value;
            return this;
        }

        public final Builder features(Function<NodeInfoSettingsTransportFeatures.Builder, ObjectBuilder<NodeInfoSettingsTransportFeatures>> fn) {
            return this.features(fn.apply(new NodeInfoSettingsTransportFeatures.Builder()).build());
        }

        public final Builder ignoreDeserializationErrors(@Nullable Boolean value) {
            this.ignoreDeserializationErrors = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NodeInfoSettingsTransport build() {
            this._checkSingleUse();
            return new NodeInfoSettingsTransport(this);
        }
    }
}

