/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class TrainedModelSizeStats
implements JsonpSerializable {
    private final String modelSizeBytes;
    private final String requiredNativeMemoryBytes;
    public static final JsonpDeserializer<TrainedModelSizeStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelSizeStats::setupTrainedModelSizeStatsDeserializer);

    private TrainedModelSizeStats(Builder builder) {
        this.modelSizeBytes = ApiTypeHelper.requireNonNull(builder.modelSizeBytes, this, "modelSizeBytes");
        this.requiredNativeMemoryBytes = ApiTypeHelper.requireNonNull(builder.requiredNativeMemoryBytes, this, "requiredNativeMemoryBytes");
    }

    public static TrainedModelSizeStats of(Function<Builder, ObjectBuilder<TrainedModelSizeStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String modelSizeBytes() {
        return this.modelSizeBytes;
    }

    public final String requiredNativeMemoryBytes() {
        return this.requiredNativeMemoryBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("model_size_bytes");
        generator.write(this.modelSizeBytes);
        generator.writeKey("required_native_memory_bytes");
        generator.write(this.requiredNativeMemoryBytes);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupTrainedModelSizeStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelSizeBytes, JsonpDeserializer.stringDeserializer(), "model_size_bytes");
        op.add(Builder::requiredNativeMemoryBytes, JsonpDeserializer.stringDeserializer(), "required_native_memory_bytes");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelSizeStats> {
        private String modelSizeBytes;
        private String requiredNativeMemoryBytes;

        public Builder() {
        }

        private Builder(TrainedModelSizeStats instance) {
            this.modelSizeBytes = instance.modelSizeBytes;
            this.requiredNativeMemoryBytes = instance.requiredNativeMemoryBytes;
        }

        public final Builder modelSizeBytes(String value) {
            this.modelSizeBytes = value;
            return this;
        }

        public final Builder requiredNativeMemoryBytes(String value) {
            this.requiredNativeMemoryBytes = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelSizeStats build() {
            this._checkSingleUse();
            return new TrainedModelSizeStats(this);
        }
    }
}

