/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license.post;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class Acknowledgement
implements JsonpSerializable {
    private final List<String> license;
    private final String message;
    public static final JsonpDeserializer<Acknowledgement> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Acknowledgement::setupAcknowledgementDeserializer);

    private Acknowledgement(Builder builder) {
        this.license = ApiTypeHelper.unmodifiableRequired(builder.license, (Object)this, "license");
        this.message = ApiTypeHelper.requireNonNull(builder.message, this, "message");
    }

    public static Acknowledgement of(Function<Builder, ObjectBuilder<Acknowledgement>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> license() {
        return this.license;
    }

    public final String message() {
        return this.message;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.license)) {
            generator.writeKey("license");
            generator.writeStartArray();
            for (String item0 : this.license) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("message");
        generator.write(this.message);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupAcknowledgementDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::license, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "license");
        op.add(Builder::message, JsonpDeserializer.stringDeserializer(), "message");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Acknowledgement> {
        private List<String> license;
        private String message;

        public Builder() {
        }

        private Builder(Acknowledgement instance) {
            this.license = instance.license;
            this.message = instance.message;
        }

        public final Builder license(List<String> list) {
            this.license = Builder._listAddAll(this.license, list);
            return this;
        }

        public final Builder license(String value, String ... values) {
            this.license = Builder._listAdd(this.license, value, values);
            return this;
        }

        public final Builder message(String value) {
            this.message = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Acknowledgement build() {
            this._checkSingleUse();
            return new Acknowledgement(this);
        }
    }
}

