/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.license;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.license.PostStartTrialResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class PostStartTrialRequest
extends RequestBase {
    @Nullable
    private final Boolean acknowledge;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String type;
    public static final Endpoint<PostStartTrialRequest, PostStartTrialResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<PostStartTrialRequest, PostStartTrialResponse>("es/license.post_start_trial", request -> "POST", request -> "/_license/start_trial", request -> Collections.emptyMap(), request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.acknowledge != null) {
            params.put("acknowledge", String.valueOf(request.acknowledge));
        }
        if (request.type != null) {
            params.put("type", request.type);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PostStartTrialResponse._DESERIALIZER);

    private PostStartTrialRequest(Builder builder) {
        this.acknowledge = builder.acknowledge;
        this.masterTimeout = builder.masterTimeout;
        this.type = builder.type;
    }

    public static PostStartTrialRequest of(Function<Builder, ObjectBuilder<PostStartTrialRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean acknowledge() {
        return this.acknowledge;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String type() {
        return this.type;
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<PostStartTrialRequest> {
        @Nullable
        private Boolean acknowledge;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String type;

        public Builder() {
        }

        private Builder(PostStartTrialRequest instance) {
            this.acknowledge = instance.acknowledge;
            this.masterTimeout = instance.masterTimeout;
            this.type = instance.type;
        }

        public final Builder acknowledge(@Nullable Boolean value) {
            this.acknowledge = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder type(@Nullable String value) {
            this.type = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PostStartTrialRequest build() {
            this._checkSingleUse();
            return new PostStartTrialRequest(this);
        }
    }
}

