/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.elasticsearch.ingest.Processor;
import co.elastic.clients.elasticsearch.ingest.ProcessorBase;
import co.elastic.clients.elasticsearch.ingest.ProcessorVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ForeachProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    private final Processor processor;
    public static final JsonpDeserializer<ForeachProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ForeachProcessor::setupForeachProcessorDeserializer);

    private ForeachProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.processor = ApiTypeHelper.requireNonNull(builder.processor, this, "processor");
    }

    public static ForeachProcessor of(Function<Builder, ObjectBuilder<ForeachProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Foreach;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    public final Processor processor() {
        return this.processor;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        generator.writeKey("processor");
        this.processor.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupForeachProcessorDeserializer(ObjectDeserializer<Builder> op) {
        ProcessorBase.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::processor, Processor._DESERIALIZER, "processor");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ForeachProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        private Processor processor;

        public Builder() {
        }

        private Builder(ForeachProcessor instance) {
            this.field = instance.field;
            this.ignoreMissing = instance.ignoreMissing;
            this.processor = instance.processor;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder processor(Processor value) {
            this.processor = value;
            return this;
        }

        public final Builder processor(Function<Processor.Builder, ObjectBuilder<Processor>> fn) {
            return this.processor(fn.apply(new Processor.Builder()).build());
        }

        public final Builder processor(ProcessorVariant value) {
            this.processor = value._toProcessor();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ForeachProcessor build() {
            this._checkSingleUse();
            return new ForeachProcessor(this);
        }
    }
}

