/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.JinaAITextEmbeddingTask;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JinaAITaskSettings
implements JsonpSerializable {
    @Nullable
    private final Boolean returnDocuments;
    @Nullable
    private final JinaAITextEmbeddingTask task;
    @Nullable
    private final Integer topN;
    public static final JsonpDeserializer<JinaAITaskSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JinaAITaskSettings::setupJinaAITaskSettingsDeserializer);

    private JinaAITaskSettings(Builder builder) {
        this.returnDocuments = builder.returnDocuments;
        this.task = builder.task;
        this.topN = builder.topN;
    }

    public static JinaAITaskSettings of(Function<Builder, ObjectBuilder<JinaAITaskSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean returnDocuments() {
        return this.returnDocuments;
    }

    @Nullable
    public final JinaAITextEmbeddingTask task() {
        return this.task;
    }

    @Nullable
    public final Integer topN() {
        return this.topN;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.returnDocuments != null) {
            generator.writeKey("return_documents");
            generator.write(this.returnDocuments.booleanValue());
        }
        if (this.task != null) {
            generator.writeKey("task");
            this.task.serialize(generator, mapper);
        }
        if (this.topN != null) {
            generator.writeKey("top_n");
            generator.write(this.topN.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupJinaAITaskSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::returnDocuments, JsonpDeserializer.booleanDeserializer(), "return_documents");
        op.add(Builder::task, JinaAITextEmbeddingTask._DESERIALIZER, "task");
        op.add(Builder::topN, JsonpDeserializer.integerDeserializer(), "top_n");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JinaAITaskSettings> {
        @Nullable
        private Boolean returnDocuments;
        @Nullable
        private JinaAITextEmbeddingTask task;
        @Nullable
        private Integer topN;

        public Builder() {
        }

        private Builder(JinaAITaskSettings instance) {
            this.returnDocuments = instance.returnDocuments;
            this.task = instance.task;
            this.topN = instance.topN;
        }

        public final Builder returnDocuments(@Nullable Boolean value) {
            this.returnDocuments = value;
            return this;
        }

        public final Builder task(@Nullable JinaAITextEmbeddingTask value) {
            this.task = value;
            return this;
        }

        public final Builder topN(@Nullable Integer value) {
            this.topN = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JinaAITaskSettings build() {
            this._checkSingleUse();
            return new JinaAITaskSettings(this);
        }
    }
}

