/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.JinaAIElementType;
import co.elastic.clients.elasticsearch.inference.JinaAISimilarityType;
import co.elastic.clients.elasticsearch.inference.RateLimitSetting;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class JinaAIServiceSettings
implements JsonpSerializable {
    private final String apiKey;
    private final String modelId;
    @Nullable
    private final RateLimitSetting rateLimit;
    @Nullable
    private final JinaAISimilarityType similarity;
    @Nullable
    private final Integer dimensions;
    @Nullable
    private final JinaAIElementType elementType;
    public static final JsonpDeserializer<JinaAIServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, JinaAIServiceSettings::setupJinaAIServiceSettingsDeserializer);

    private JinaAIServiceSettings(Builder builder) {
        this.apiKey = ApiTypeHelper.requireNonNull(builder.apiKey, this, "apiKey");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.rateLimit = builder.rateLimit;
        this.similarity = builder.similarity;
        this.dimensions = builder.dimensions;
        this.elementType = builder.elementType;
    }

    public static JinaAIServiceSettings of(Function<Builder, ObjectBuilder<JinaAIServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String apiKey() {
        return this.apiKey;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final RateLimitSetting rateLimit() {
        return this.rateLimit;
    }

    @Nullable
    public final JinaAISimilarityType similarity() {
        return this.similarity;
    }

    @Nullable
    public final Integer dimensions() {
        return this.dimensions;
    }

    @Nullable
    public final JinaAIElementType elementType() {
        return this.elementType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("api_key");
        generator.write(this.apiKey);
        generator.writeKey("model_id");
        generator.write(this.modelId);
        if (this.rateLimit != null) {
            generator.writeKey("rate_limit");
            this.rateLimit.serialize(generator, mapper);
        }
        if (this.similarity != null) {
            generator.writeKey("similarity");
            this.similarity.serialize(generator, mapper);
        }
        if (this.dimensions != null) {
            generator.writeKey("dimensions");
            generator.write(this.dimensions.intValue());
        }
        if (this.elementType != null) {
            generator.writeKey("element_type");
            this.elementType.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupJinaAIServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::apiKey, JsonpDeserializer.stringDeserializer(), "api_key");
        op.add(Builder::modelId, JsonpDeserializer.stringDeserializer(), "model_id");
        op.add(Builder::rateLimit, RateLimitSetting._DESERIALIZER, "rate_limit");
        op.add(Builder::similarity, JinaAISimilarityType._DESERIALIZER, "similarity");
        op.add(Builder::dimensions, JsonpDeserializer.integerDeserializer(), "dimensions");
        op.add(Builder::elementType, JinaAIElementType._DESERIALIZER, "element_type");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<JinaAIServiceSettings> {
        private String apiKey;
        private String modelId;
        @Nullable
        private RateLimitSetting rateLimit;
        @Nullable
        private JinaAISimilarityType similarity;
        @Nullable
        private Integer dimensions;
        @Nullable
        private JinaAIElementType elementType;

        public Builder() {
        }

        private Builder(JinaAIServiceSettings instance) {
            this.apiKey = instance.apiKey;
            this.modelId = instance.modelId;
            this.rateLimit = instance.rateLimit;
            this.similarity = instance.similarity;
            this.dimensions = instance.dimensions;
            this.elementType = instance.elementType;
        }

        public final Builder apiKey(String value) {
            this.apiKey = value;
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder rateLimit(@Nullable RateLimitSetting value) {
            this.rateLimit = value;
            return this;
        }

        public final Builder rateLimit(Function<RateLimitSetting.Builder, ObjectBuilder<RateLimitSetting>> fn) {
            return this.rateLimit(fn.apply(new RateLimitSetting.Builder()).build());
        }

        public final Builder similarity(@Nullable JinaAISimilarityType value) {
            this.similarity = value;
            return this;
        }

        public final Builder dimensions(@Nullable Integer value) {
            this.dimensions = value;
            return this;
        }

        public final Builder elementType(@Nullable JinaAIElementType value) {
            this.elementType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public JinaAIServiceSettings build() {
            this._checkSingleUse();
            return new JinaAIServiceSettings(this);
        }
    }
}

