/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch.inference.AdaptiveAllocations;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ElserServiceSettings
implements JsonpSerializable {
    @Nullable
    private final AdaptiveAllocations adaptiveAllocations;
    private final int numAllocations;
    private final int numThreads;
    public static final JsonpDeserializer<ElserServiceSettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ElserServiceSettings::setupElserServiceSettingsDeserializer);

    private ElserServiceSettings(Builder builder) {
        this.adaptiveAllocations = builder.adaptiveAllocations;
        this.numAllocations = ApiTypeHelper.requireNonNull(builder.numAllocations, (Object)this, "numAllocations", 0);
        this.numThreads = ApiTypeHelper.requireNonNull(builder.numThreads, (Object)this, "numThreads", 0);
    }

    public static ElserServiceSettings of(Function<Builder, ObjectBuilder<ElserServiceSettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AdaptiveAllocations adaptiveAllocations() {
        return this.adaptiveAllocations;
    }

    public final int numAllocations() {
        return this.numAllocations;
    }

    public final int numThreads() {
        return this.numThreads;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.adaptiveAllocations != null) {
            generator.writeKey("adaptive_allocations");
            this.adaptiveAllocations.serialize(generator, mapper);
        }
        generator.writeKey("num_allocations");
        generator.write(this.numAllocations);
        generator.writeKey("num_threads");
        generator.write(this.numThreads);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupElserServiceSettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::adaptiveAllocations, AdaptiveAllocations._DESERIALIZER, "adaptive_allocations");
        op.add(Builder::numAllocations, JsonpDeserializer.integerDeserializer(), "num_allocations");
        op.add(Builder::numThreads, JsonpDeserializer.integerDeserializer(), "num_threads");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ElserServiceSettings> {
        @Nullable
        private AdaptiveAllocations adaptiveAllocations;
        private Integer numAllocations;
        private Integer numThreads;

        public Builder() {
        }

        private Builder(ElserServiceSettings instance) {
            this.adaptiveAllocations = instance.adaptiveAllocations;
            this.numAllocations = instance.numAllocations;
            this.numThreads = instance.numThreads;
        }

        public final Builder adaptiveAllocations(@Nullable AdaptiveAllocations value) {
            this.adaptiveAllocations = value;
            return this;
        }

        public final Builder adaptiveAllocations(Function<AdaptiveAllocations.Builder, ObjectBuilder<AdaptiveAllocations>> fn) {
            return this.adaptiveAllocations(fn.apply(new AdaptiveAllocations.Builder()).build());
        }

        public final Builder numAllocations(int value) {
            this.numAllocations = value;
            return this;
        }

        public final Builder numThreads(int value) {
            this.numThreads = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ElserServiceSettings build() {
            this._checkSingleUse();
            return new ElserServiceSettings(this);
        }
    }
}

