/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.inference.RequestChatCompletion;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.BinaryEndpoint;
import co.elastic.clients.transport.endpoints.BinaryResponse;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChatCompletionUnifiedRequest
extends RequestBase
implements JsonpSerializable {
    private final String inferenceId;
    @Nullable
    private final Time timeout;
    private final RequestChatCompletion chatCompletionRequest;
    public static final JsonpDeserializer<ChatCompletionUnifiedRequest> _DESERIALIZER = ChatCompletionUnifiedRequest.createChatCompletionUnifiedRequestDeserializer();
    public static final Endpoint<ChatCompletionUnifiedRequest, BinaryResponse, ErrorResponse> _ENDPOINT = new BinaryEndpoint<ChatCompletionUnifiedRequest>("es/inference.chat_completion_unified", request -> "POST", request -> {
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/chat_completion");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.inferenceId, buf);
            buf.append("/_stream");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _inferenceId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("inferenceId", request.inferenceId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.timeout != null) {
            params.put("timeout", request.timeout._toJsonString());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, null);

    private ChatCompletionUnifiedRequest(Builder builder) {
        this.inferenceId = ApiTypeHelper.requireNonNull(builder.inferenceId, this, "inferenceId");
        this.timeout = builder.timeout;
        this.chatCompletionRequest = ApiTypeHelper.requireNonNull(builder.chatCompletionRequest, this, "chatCompletionRequest");
    }

    public static ChatCompletionUnifiedRequest of(Function<Builder, ObjectBuilder<ChatCompletionUnifiedRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String inferenceId() {
        return this.inferenceId;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    public final RequestChatCompletion chatCompletionRequest() {
        return this.chatCompletionRequest;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.chatCompletionRequest.serialize(generator, mapper);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static JsonpDeserializer<ChatCompletionUnifiedRequest> createChatCompletionUnifiedRequestDeserializer() {
        JsonpDeserializer<RequestChatCompletion> valueDeserializer = RequestChatCompletion._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().chatCompletionRequest((RequestChatCompletion)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ChatCompletionUnifiedRequest> {
        private String inferenceId;
        @Nullable
        private Time timeout;
        private RequestChatCompletion chatCompletionRequest;

        public Builder() {
        }

        private Builder(ChatCompletionUnifiedRequest instance) {
            this.inferenceId = instance.inferenceId;
            this.timeout = instance.timeout;
            this.chatCompletionRequest = instance.chatCompletionRequest;
        }

        public final Builder inferenceId(String value) {
            this.inferenceId = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder chatCompletionRequest(RequestChatCompletion value) {
            this.chatCompletionRequest = value;
            return this;
        }

        public final Builder chatCompletionRequest(Function<RequestChatCompletion.Builder, ObjectBuilder<RequestChatCompletion>> fn) {
            return this.chatCompletionRequest(fn.apply(new RequestChatCompletion.Builder()).build());
        }

        @Override
        public Builder withJson(JsonParser parser, JsonpMapper mapper) {
            RequestChatCompletion value = RequestChatCompletion._DESERIALIZER.deserialize(parser, mapper);
            return this.chatCompletionRequest(value);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChatCompletionUnifiedRequest build() {
            this._checkSingleUse();
            return new ChatCompletionUnifiedRequest(this);
        }
    }
}

