/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ilm.explain_lifecycle;

import co.elastic.clients.elasticsearch.ilm.Phase;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class LifecycleExplainPhaseExecution
implements JsonpSerializable {
    @Nullable
    private final Phase phaseDefinition;
    private final String policy;
    private final long version;
    private final long modifiedDateInMillis;
    public static final JsonpDeserializer<LifecycleExplainPhaseExecution> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LifecycleExplainPhaseExecution::setupLifecycleExplainPhaseExecutionDeserializer);

    private LifecycleExplainPhaseExecution(Builder builder) {
        this.phaseDefinition = builder.phaseDefinition;
        this.policy = ApiTypeHelper.requireNonNull(builder.policy, this, "policy");
        this.version = ApiTypeHelper.requireNonNull(builder.version, (Object)this, "version", 0L);
        this.modifiedDateInMillis = ApiTypeHelper.requireNonNull(builder.modifiedDateInMillis, (Object)this, "modifiedDateInMillis", 0L);
    }

    public static LifecycleExplainPhaseExecution of(Function<Builder, ObjectBuilder<LifecycleExplainPhaseExecution>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Phase phaseDefinition() {
        return this.phaseDefinition;
    }

    public final String policy() {
        return this.policy;
    }

    public final long version() {
        return this.version;
    }

    public final long modifiedDateInMillis() {
        return this.modifiedDateInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.phaseDefinition != null) {
            generator.writeKey("phase_definition");
            this.phaseDefinition.serialize(generator, mapper);
        }
        generator.writeKey("policy");
        generator.write(this.policy);
        generator.writeKey("version");
        generator.write(this.version);
        generator.writeKey("modified_date_in_millis");
        generator.write(this.modifiedDateInMillis);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupLifecycleExplainPhaseExecutionDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::phaseDefinition, Phase._DESERIALIZER, "phase_definition");
        op.add(Builder::policy, JsonpDeserializer.stringDeserializer(), "policy");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::modifiedDateInMillis, JsonpDeserializer.longDeserializer(), "modified_date_in_millis");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<LifecycleExplainPhaseExecution> {
        @Nullable
        private Phase phaseDefinition;
        private String policy;
        private Long version;
        private Long modifiedDateInMillis;

        public Builder() {
        }

        private Builder(LifecycleExplainPhaseExecution instance) {
            this.phaseDefinition = instance.phaseDefinition;
            this.policy = instance.policy;
            this.version = instance.version;
            this.modifiedDateInMillis = instance.modifiedDateInMillis;
        }

        public final Builder phaseDefinition(@Nullable Phase value) {
            this.phaseDefinition = value;
            return this;
        }

        public final Builder phaseDefinition(Function<Phase.Builder, ObjectBuilder<Phase>> fn) {
            return this.phaseDefinition(fn.apply(new Phase.Builder()).build());
        }

        public final Builder policy(String value) {
            this.policy = value;
            return this;
        }

        public final Builder version(long value) {
            this.version = value;
            return this;
        }

        public final Builder modifiedDateInMillis(long value) {
            this.modifiedDateInMillis = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public LifecycleExplainPhaseExecution build() {
            this._checkSingleUse();
            return new LifecycleExplainPhaseExecution(this);
        }
    }
}

