/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.termvectors;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class FieldStatistics
implements JsonpSerializable {
    private final int docCount;
    private final long sumDocFreq;
    private final long sumTtf;
    public static final JsonpDeserializer<FieldStatistics> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldStatistics::setupFieldStatisticsDeserializer);

    private FieldStatistics(Builder builder) {
        this.docCount = ApiTypeHelper.requireNonNull(builder.docCount, (Object)this, "docCount", 0);
        this.sumDocFreq = ApiTypeHelper.requireNonNull(builder.sumDocFreq, (Object)this, "sumDocFreq", 0L);
        this.sumTtf = ApiTypeHelper.requireNonNull(builder.sumTtf, (Object)this, "sumTtf", 0L);
    }

    public static FieldStatistics of(Function<Builder, ObjectBuilder<FieldStatistics>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int docCount() {
        return this.docCount;
    }

    public final long sumDocFreq() {
        return this.sumDocFreq;
    }

    public final long sumTtf() {
        return this.sumTtf;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("doc_count");
        generator.write(this.docCount);
        generator.writeKey("sum_doc_freq");
        generator.write(this.sumDocFreq);
        generator.writeKey("sum_ttf");
        generator.write(this.sumTtf);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldStatisticsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::docCount, JsonpDeserializer.integerDeserializer(), "doc_count");
        op.add(Builder::sumDocFreq, JsonpDeserializer.longDeserializer(), "sum_doc_freq");
        op.add(Builder::sumTtf, JsonpDeserializer.longDeserializer(), "sum_ttf");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldStatistics> {
        private Integer docCount;
        private Long sumDocFreq;
        private Long sumTtf;

        public Builder() {
        }

        private Builder(FieldStatistics instance) {
            this.docCount = instance.docCount;
            this.sumDocFreq = instance.sumDocFreq;
            this.sumTtf = instance.sumTtf;
        }

        public final Builder docCount(int value) {
            this.docCount = value;
            return this;
        }

        public final Builder sumDocFreq(long value) {
            this.sumDocFreq = value;
            return this;
        }

        public final Builder sumTtf(long value) {
            this.sumTtf = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldStatistics build() {
            this._checkSingleUse();
            return new FieldStatistics(this);
        }
    }
}

