/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.InnerHits;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FieldCollapse
implements JsonpSerializable {
    private final String field;
    private final List<InnerHits> innerHits;
    @Nullable
    private final Integer maxConcurrentGroupSearches;
    @Nullable
    private final FieldCollapse collapse;
    public static final JsonpDeserializer<FieldCollapse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FieldCollapse::setupFieldCollapseDeserializer);

    private FieldCollapse(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.innerHits = ApiTypeHelper.unmodifiable(builder.innerHits);
        this.maxConcurrentGroupSearches = builder.maxConcurrentGroupSearches;
        this.collapse = builder.collapse;
    }

    public static FieldCollapse of(Function<Builder, ObjectBuilder<FieldCollapse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    public final List<InnerHits> innerHits() {
        return this.innerHits;
    }

    @Nullable
    public final Integer maxConcurrentGroupSearches() {
        return this.maxConcurrentGroupSearches;
    }

    @Nullable
    public final FieldCollapse collapse() {
        return this.collapse;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.innerHits)) {
            generator.writeKey("inner_hits");
            generator.writeStartArray();
            for (InnerHits item0 : this.innerHits) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.maxConcurrentGroupSearches != null) {
            generator.writeKey("max_concurrent_group_searches");
            generator.write(this.maxConcurrentGroupSearches.intValue());
        }
        if (this.collapse != null) {
            generator.writeKey("collapse");
            this.collapse.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupFieldCollapseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::innerHits, JsonpDeserializer.arrayDeserializer(InnerHits._DESERIALIZER), "inner_hits");
        op.add(Builder::maxConcurrentGroupSearches, JsonpDeserializer.integerDeserializer(), "max_concurrent_group_searches");
        op.add(Builder::collapse, _DESERIALIZER, "collapse");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FieldCollapse> {
        private String field;
        @Nullable
        private List<InnerHits> innerHits;
        @Nullable
        private Integer maxConcurrentGroupSearches;
        @Nullable
        private FieldCollapse collapse;

        public Builder() {
        }

        private Builder(FieldCollapse instance) {
            this.field = instance.field;
            this.innerHits = instance.innerHits;
            this.maxConcurrentGroupSearches = instance.maxConcurrentGroupSearches;
            this.collapse = instance.collapse;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder innerHits(List<InnerHits> list) {
            this.innerHits = Builder._listAddAll(this.innerHits, list);
            return this;
        }

        public final Builder innerHits(InnerHits value, InnerHits ... values) {
            this.innerHits = Builder._listAdd(this.innerHits, value, values);
            return this;
        }

        public final Builder innerHits(Function<InnerHits.Builder, ObjectBuilder<InnerHits>> fn) {
            return this.innerHits(fn.apply(new InnerHits.Builder()).build(), new InnerHits[0]);
        }

        public final Builder maxConcurrentGroupSearches(@Nullable Integer value) {
            this.maxConcurrentGroupSearches = value;
            return this;
        }

        public final Builder collapse(@Nullable FieldCollapse value) {
            this.collapse = value;
            return this;
        }

        public final Builder collapse(Function<Builder, ObjectBuilder<FieldCollapse>> fn) {
            return this.collapse(fn.apply(new Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FieldCollapse build() {
            this._checkSingleUse();
            return new FieldCollapse(this);
        }
    }
}

