/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.msearch;

import co.elastic.clients.elasticsearch._types.ExpandWildcard;
import co.elastic.clients.elasticsearch._types.SearchType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class MultisearchHeader
implements JsonpSerializable {
    @Nullable
    private final Boolean allowNoIndices;
    private final List<ExpandWildcard> expandWildcards;
    @Nullable
    private final Boolean ignoreUnavailable;
    private final List<String> index;
    @Nullable
    private final String preference;
    @Nullable
    private final Boolean requestCache;
    @Nullable
    private final String routing;
    @Nullable
    private final SearchType searchType;
    @Nullable
    private final Boolean ccsMinimizeRoundtrips;
    @Nullable
    private final Boolean allowPartialSearchResults;
    @Nullable
    private final Boolean ignoreThrottled;
    public static final JsonpDeserializer<MultisearchHeader> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MultisearchHeader::setupMultisearchHeaderDeserializer);

    private MultisearchHeader(Builder builder) {
        this.allowNoIndices = builder.allowNoIndices;
        this.expandWildcards = ApiTypeHelper.unmodifiable(builder.expandWildcards);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.index = ApiTypeHelper.unmodifiable(builder.index);
        this.preference = builder.preference;
        this.requestCache = builder.requestCache;
        this.routing = builder.routing;
        this.searchType = builder.searchType;
        this.ccsMinimizeRoundtrips = builder.ccsMinimizeRoundtrips;
        this.allowPartialSearchResults = builder.allowPartialSearchResults;
        this.ignoreThrottled = builder.ignoreThrottled;
    }

    public static MultisearchHeader of(Function<Builder, ObjectBuilder<MultisearchHeader>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    public final List<ExpandWildcard> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    public final List<String> index() {
        return this.index;
    }

    @Nullable
    public final String preference() {
        return this.preference;
    }

    @Nullable
    public final Boolean requestCache() {
        return this.requestCache;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final SearchType searchType() {
        return this.searchType;
    }

    @Nullable
    public final Boolean ccsMinimizeRoundtrips() {
        return this.ccsMinimizeRoundtrips;
    }

    @Nullable
    public final Boolean allowPartialSearchResults() {
        return this.allowPartialSearchResults;
    }

    @Nullable
    public final Boolean ignoreThrottled() {
        return this.ignoreThrottled;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.allowNoIndices != null) {
            generator.writeKey("allow_no_indices");
            generator.write(this.allowNoIndices.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.expandWildcards)) {
            generator.writeKey("expand_wildcards");
            generator.writeStartArray();
            for (ExpandWildcard expandWildcard : this.expandWildcards) {
                expandWildcard.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ignoreUnavailable != null) {
            generator.writeKey("ignore_unavailable");
            generator.write(this.ignoreUnavailable.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (String string : this.index) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.preference != null) {
            generator.writeKey("preference");
            generator.write(this.preference);
        }
        if (this.requestCache != null) {
            generator.writeKey("request_cache");
            generator.write(this.requestCache.booleanValue());
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.searchType != null) {
            generator.writeKey("search_type");
            this.searchType.serialize(generator, mapper);
        }
        if (this.ccsMinimizeRoundtrips != null) {
            generator.writeKey("ccs_minimize_roundtrips");
            generator.write(this.ccsMinimizeRoundtrips.booleanValue());
        }
        if (this.allowPartialSearchResults != null) {
            generator.writeKey("allow_partial_search_results");
            generator.write(this.allowPartialSearchResults.booleanValue());
        }
        if (this.ignoreThrottled != null) {
            generator.writeKey("ignore_throttled");
            generator.write(this.ignoreThrottled.booleanValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupMultisearchHeaderDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allowNoIndices, JsonpDeserializer.booleanDeserializer(), "allow_no_indices");
        op.add(Builder::expandWildcards, JsonpDeserializer.arrayDeserializer(ExpandWildcard._DESERIALIZER), "expand_wildcards");
        op.add(Builder::ignoreUnavailable, JsonpDeserializer.booleanDeserializer(), "ignore_unavailable");
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "index");
        op.add(Builder::preference, JsonpDeserializer.stringDeserializer(), "preference");
        op.add(Builder::requestCache, JsonpDeserializer.booleanDeserializer(), "request_cache");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::searchType, SearchType._DESERIALIZER, "search_type");
        op.add(Builder::ccsMinimizeRoundtrips, JsonpDeserializer.booleanDeserializer(), "ccs_minimize_roundtrips");
        op.add(Builder::allowPartialSearchResults, JsonpDeserializer.booleanDeserializer(), "allow_partial_search_results");
        op.add(Builder::ignoreThrottled, JsonpDeserializer.booleanDeserializer(), "ignore_throttled");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<MultisearchHeader> {
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private List<ExpandWildcard> expandWildcards;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private List<String> index;
        @Nullable
        private String preference;
        @Nullable
        private Boolean requestCache;
        @Nullable
        private String routing;
        @Nullable
        private SearchType searchType;
        @Nullable
        private Boolean ccsMinimizeRoundtrips;
        @Nullable
        private Boolean allowPartialSearchResults;
        @Nullable
        private Boolean ignoreThrottled;

        public Builder() {
        }

        private Builder(MultisearchHeader instance) {
            this.allowNoIndices = instance.allowNoIndices;
            this.expandWildcards = instance.expandWildcards;
            this.ignoreUnavailable = instance.ignoreUnavailable;
            this.index = instance.index;
            this.preference = instance.preference;
            this.requestCache = instance.requestCache;
            this.routing = instance.routing;
            this.searchType = instance.searchType;
            this.ccsMinimizeRoundtrips = instance.ccsMinimizeRoundtrips;
            this.allowPartialSearchResults = instance.allowPartialSearchResults;
            this.ignoreThrottled = instance.ignoreThrottled;
        }

        public final Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public final Builder expandWildcards(List<ExpandWildcard> list) {
            this.expandWildcards = Builder._listAddAll(this.expandWildcards, list);
            return this;
        }

        public final Builder expandWildcards(ExpandWildcard value, ExpandWildcard ... values) {
            this.expandWildcards = Builder._listAdd(this.expandWildcards, value, values);
            return this;
        }

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder index(List<String> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(String value, String ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder preference(@Nullable String value) {
            this.preference = value;
            return this;
        }

        public final Builder requestCache(@Nullable Boolean value) {
            this.requestCache = value;
            return this;
        }

        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        public final Builder searchType(@Nullable SearchType value) {
            this.searchType = value;
            return this;
        }

        public final Builder ccsMinimizeRoundtrips(@Nullable Boolean value) {
            this.ccsMinimizeRoundtrips = value;
            return this;
        }

        public final Builder allowPartialSearchResults(@Nullable Boolean value) {
            this.allowPartialSearchResults = value;
            return this;
        }

        public final Builder ignoreThrottled(@Nullable Boolean value) {
            this.ignoreThrottled = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MultisearchHeader build() {
            this._checkSingleUse();
            return new MultisearchHeader(this);
        }
    }
}

