/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class IndicatorNode
implements JsonpSerializable {
    @Nullable
    private final String name;
    @Nullable
    private final String nodeId;
    public static final JsonpDeserializer<IndicatorNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndicatorNode::setupIndicatorNodeDeserializer);

    private IndicatorNode(Builder builder) {
        this.name = builder.name;
        this.nodeId = builder.nodeId;
    }

    public static IndicatorNode of(Function<Builder, ObjectBuilder<IndicatorNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String name() {
        return this.name;
    }

    @Nullable
    public final String nodeId() {
        return this.nodeId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.nodeId != null) {
            generator.writeKey("node_id");
            generator.write(this.nodeId);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIndicatorNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IndicatorNode> {
        @Nullable
        private String name;
        @Nullable
        private String nodeId;

        public Builder() {
        }

        private Builder(IndicatorNode instance) {
            this.name = instance.name;
            this.nodeId = instance.nodeId;
        }

        public final Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public final Builder nodeId(@Nullable String value) {
            this.nodeId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IndicatorNode build() {
            this._checkSingleUse();
            return new IndicatorNode(this);
        }
    }
}

