/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class IngestPipelineParams
implements JsonpSerializable {
    private final boolean extractBinaryContent;
    private final String name;
    private final boolean reduceWhitespace;
    private final boolean runMlInference;
    public static final JsonpDeserializer<IngestPipelineParams> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IngestPipelineParams::setupIngestPipelineParamsDeserializer);

    private IngestPipelineParams(Builder builder) {
        this.extractBinaryContent = ApiTypeHelper.requireNonNull(builder.extractBinaryContent, (Object)this, "extractBinaryContent", false);
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.reduceWhitespace = ApiTypeHelper.requireNonNull(builder.reduceWhitespace, (Object)this, "reduceWhitespace", false);
        this.runMlInference = ApiTypeHelper.requireNonNull(builder.runMlInference, (Object)this, "runMlInference", false);
    }

    public static IngestPipelineParams of(Function<Builder, ObjectBuilder<IngestPipelineParams>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean extractBinaryContent() {
        return this.extractBinaryContent;
    }

    public final String name() {
        return this.name;
    }

    public final boolean reduceWhitespace() {
        return this.reduceWhitespace;
    }

    public final boolean runMlInference() {
        return this.runMlInference;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("extract_binary_content");
        generator.write(this.extractBinaryContent);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("reduce_whitespace");
        generator.write(this.reduceWhitespace);
        generator.writeKey("run_ml_inference");
        generator.write(this.runMlInference);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupIngestPipelineParamsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::extractBinaryContent, JsonpDeserializer.booleanDeserializer(), "extract_binary_content");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::reduceWhitespace, JsonpDeserializer.booleanDeserializer(), "reduce_whitespace");
        op.add(Builder::runMlInference, JsonpDeserializer.booleanDeserializer(), "run_ml_inference");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<IngestPipelineParams> {
        private Boolean extractBinaryContent;
        private String name;
        private Boolean reduceWhitespace;
        private Boolean runMlInference;

        public Builder() {
        }

        private Builder(IngestPipelineParams instance) {
            this.extractBinaryContent = instance.extractBinaryContent;
            this.name = instance.name;
            this.reduceWhitespace = instance.reduceWhitespace;
            this.runMlInference = instance.runMlInference;
        }

        public final Builder extractBinaryContent(boolean value) {
            this.extractBinaryContent = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder reduceWhitespace(boolean value) {
            this.reduceWhitespace = value;
            return this;
        }

        public final Builder runMlInference(boolean value) {
            this.runMlInference = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IngestPipelineParams build() {
            this._checkSingleUse();
            return new IngestPipelineParams(this);
        }
    }
}

