/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SnapshotCurrentCounts
implements JsonpSerializable {
    private final int snapshots;
    private final int shardSnapshots;
    private final int snapshotDeletions;
    private final int concurrentOperations;
    private final int cleanups;
    public static final JsonpDeserializer<SnapshotCurrentCounts> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SnapshotCurrentCounts::setupSnapshotCurrentCountsDeserializer);

    private SnapshotCurrentCounts(Builder builder) {
        this.snapshots = ApiTypeHelper.requireNonNull(builder.snapshots, (Object)this, "snapshots", 0);
        this.shardSnapshots = ApiTypeHelper.requireNonNull(builder.shardSnapshots, (Object)this, "shardSnapshots", 0);
        this.snapshotDeletions = ApiTypeHelper.requireNonNull(builder.snapshotDeletions, (Object)this, "snapshotDeletions", 0);
        this.concurrentOperations = ApiTypeHelper.requireNonNull(builder.concurrentOperations, (Object)this, "concurrentOperations", 0);
        this.cleanups = ApiTypeHelper.requireNonNull(builder.cleanups, (Object)this, "cleanups", 0);
    }

    public static SnapshotCurrentCounts of(Function<Builder, ObjectBuilder<SnapshotCurrentCounts>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int snapshots() {
        return this.snapshots;
    }

    public final int shardSnapshots() {
        return this.shardSnapshots;
    }

    public final int snapshotDeletions() {
        return this.snapshotDeletions;
    }

    public final int concurrentOperations() {
        return this.concurrentOperations;
    }

    public final int cleanups() {
        return this.cleanups;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshots");
        generator.write(this.snapshots);
        generator.writeKey("shard_snapshots");
        generator.write(this.shardSnapshots);
        generator.writeKey("snapshot_deletions");
        generator.write(this.snapshotDeletions);
        generator.writeKey("concurrent_operations");
        generator.write(this.concurrentOperations);
        generator.writeKey("cleanups");
        generator.write(this.cleanups);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupSnapshotCurrentCountsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::snapshots, JsonpDeserializer.integerDeserializer(), "snapshots");
        op.add(Builder::shardSnapshots, JsonpDeserializer.integerDeserializer(), "shard_snapshots");
        op.add(Builder::snapshotDeletions, JsonpDeserializer.integerDeserializer(), "snapshot_deletions");
        op.add(Builder::concurrentOperations, JsonpDeserializer.integerDeserializer(), "concurrent_operations");
        op.add(Builder::cleanups, JsonpDeserializer.integerDeserializer(), "cleanups");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SnapshotCurrentCounts> {
        private Integer snapshots;
        private Integer shardSnapshots;
        private Integer snapshotDeletions;
        private Integer concurrentOperations;
        private Integer cleanups;

        public Builder() {
        }

        private Builder(SnapshotCurrentCounts instance) {
            this.snapshots = instance.snapshots;
            this.shardSnapshots = instance.shardSnapshots;
            this.snapshotDeletions = instance.snapshotDeletions;
            this.concurrentOperations = instance.concurrentOperations;
            this.cleanups = instance.cleanups;
        }

        public final Builder snapshots(int value) {
            this.snapshots = value;
            return this;
        }

        public final Builder shardSnapshots(int value) {
            this.shardSnapshots = value;
            return this;
        }

        public final Builder snapshotDeletions(int value) {
            this.snapshotDeletions = value;
            return this;
        }

        public final Builder concurrentOperations(int value) {
            this.concurrentOperations = value;
            return this;
        }

        public final Builder cleanups(int value) {
            this.cleanups = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotCurrentCounts build() {
            this._checkSingleUse();
            return new SnapshotCurrentCounts(this);
        }
    }
}

