/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.RepositoryStatsCurrentCounts;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PerRepositoryStats
implements JsonpSerializable {
    private final String type;
    private final long oldestStartTimeMillis;
    @Nullable
    private final String oldestStartTime;
    private final RepositoryStatsCurrentCounts currentCounts;
    public static final JsonpDeserializer<PerRepositoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PerRepositoryStats::setupPerRepositoryStatsDeserializer);

    private PerRepositoryStats(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.oldestStartTimeMillis = ApiTypeHelper.requireNonNull(builder.oldestStartTimeMillis, (Object)this, "oldestStartTimeMillis", 0L);
        this.oldestStartTime = builder.oldestStartTime;
        this.currentCounts = ApiTypeHelper.requireNonNull(builder.currentCounts, this, "currentCounts");
    }

    public static PerRepositoryStats of(Function<Builder, ObjectBuilder<PerRepositoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    public final long oldestStartTimeMillis() {
        return this.oldestStartTimeMillis;
    }

    @Nullable
    public final String oldestStartTime() {
        return this.oldestStartTime;
    }

    public final RepositoryStatsCurrentCounts currentCounts() {
        return this.currentCounts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("oldest_start_time_millis");
        generator.write(this.oldestStartTimeMillis);
        if (this.oldestStartTime != null) {
            generator.writeKey("oldest_start_time");
            generator.write(this.oldestStartTime);
        }
        generator.writeKey("current_counts");
        this.currentCounts.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupPerRepositoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::oldestStartTimeMillis, JsonpDeserializer.longDeserializer(), "oldest_start_time_millis");
        op.add(Builder::oldestStartTime, JsonpDeserializer.stringDeserializer(), "oldest_start_time");
        op.add(Builder::currentCounts, RepositoryStatsCurrentCounts._DESERIALIZER, "current_counts");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<PerRepositoryStats> {
        private String type;
        private Long oldestStartTimeMillis;
        @Nullable
        private String oldestStartTime;
        private RepositoryStatsCurrentCounts currentCounts;

        public Builder() {
        }

        private Builder(PerRepositoryStats instance) {
            this.type = instance.type;
            this.oldestStartTimeMillis = instance.oldestStartTimeMillis;
            this.oldestStartTime = instance.oldestStartTime;
            this.currentCounts = instance.currentCounts;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder oldestStartTimeMillis(long value) {
            this.oldestStartTimeMillis = value;
            return this;
        }

        public final Builder oldestStartTime(@Nullable String value) {
            this.oldestStartTime = value;
            return this;
        }

        public final Builder currentCounts(RepositoryStatsCurrentCounts value) {
            this.currentCounts = value;
            return this;
        }

        public final Builder currentCounts(Function<RepositoryStatsCurrentCounts.Builder, ObjectBuilder<RepositoryStatsCurrentCounts>> fn) {
            return this.currentCounts(fn.apply(new RepositoryStatsCurrentCounts.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public PerRepositoryStats build() {
            this._checkSingleUse();
            return new PerRepositoryStats(this);
        }
    }
}

