/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.DenseVectorOffHeapStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class DenseVectorStats
implements JsonpSerializable {
    private final long valueCount;
    @Nullable
    private final DenseVectorOffHeapStats offHeap;
    public static final JsonpDeserializer<DenseVectorStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DenseVectorStats::setupDenseVectorStatsDeserializer);

    private DenseVectorStats(Builder builder) {
        this.valueCount = ApiTypeHelper.requireNonNull(builder.valueCount, (Object)this, "valueCount", 0L);
        this.offHeap = builder.offHeap;
    }

    public static DenseVectorStats of(Function<Builder, ObjectBuilder<DenseVectorStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long valueCount() {
        return this.valueCount;
    }

    @Nullable
    public final DenseVectorOffHeapStats offHeap() {
        return this.offHeap;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("value_count");
        generator.write(this.valueCount);
        if (this.offHeap != null) {
            generator.writeKey("off_heap");
            this.offHeap.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupDenseVectorStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::valueCount, JsonpDeserializer.longDeserializer(), "value_count");
        op.add(Builder::offHeap, DenseVectorOffHeapStats._DESERIALIZER, "off_heap");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DenseVectorStats> {
        private Long valueCount;
        @Nullable
        private DenseVectorOffHeapStats offHeap;

        public Builder() {
        }

        private Builder(DenseVectorStats instance) {
            this.valueCount = instance.valueCount;
            this.offHeap = instance.offHeap;
        }

        public final Builder valueCount(long value) {
            this.valueCount = value;
            return this;
        }

        public final Builder offHeap(@Nullable DenseVectorOffHeapStats value) {
            this.offHeap = value;
            return this;
        }

        public final Builder offHeap(Function<DenseVectorOffHeapStats.Builder, ObjectBuilder<DenseVectorOffHeapStats>> fn) {
            return this.offHeap(fn.apply(new DenseVectorOffHeapStats.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DenseVectorStats build() {
            this._checkSingleUse();
            return new DenseVectorStats(this);
        }
    }
}

