/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.cluster.stats;

import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemArchitecture;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemName;
import co.elastic.clients.elasticsearch.cluster.stats.ClusterOperatingSystemPrettyName;
import co.elastic.clients.elasticsearch.cluster.stats.OperatingSystemMemoryInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ClusterOperatingSystem
implements JsonpSerializable {
    private final int allocatedProcessors;
    private final List<ClusterOperatingSystemArchitecture> architectures;
    private final int availableProcessors;
    private final OperatingSystemMemoryInfo mem;
    private final List<ClusterOperatingSystemName> names;
    private final List<ClusterOperatingSystemPrettyName> prettyNames;
    public static final JsonpDeserializer<ClusterOperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterOperatingSystem::setupClusterOperatingSystemDeserializer);

    private ClusterOperatingSystem(Builder builder) {
        this.allocatedProcessors = ApiTypeHelper.requireNonNull(builder.allocatedProcessors, (Object)this, "allocatedProcessors", 0);
        this.architectures = ApiTypeHelper.unmodifiable(builder.architectures);
        this.availableProcessors = ApiTypeHelper.requireNonNull(builder.availableProcessors, (Object)this, "availableProcessors", 0);
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.names = ApiTypeHelper.unmodifiableRequired(builder.names, (Object)this, "names");
        this.prettyNames = ApiTypeHelper.unmodifiableRequired(builder.prettyNames, (Object)this, "prettyNames");
    }

    public static ClusterOperatingSystem of(Function<Builder, ObjectBuilder<ClusterOperatingSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int allocatedProcessors() {
        return this.allocatedProcessors;
    }

    public final List<ClusterOperatingSystemArchitecture> architectures() {
        return this.architectures;
    }

    public final int availableProcessors() {
        return this.availableProcessors;
    }

    public final OperatingSystemMemoryInfo mem() {
        return this.mem;
    }

    public final List<ClusterOperatingSystemName> names() {
        return this.names;
    }

    public final List<ClusterOperatingSystemPrettyName> prettyNames() {
        return this.prettyNames;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("allocated_processors");
        generator.write(this.allocatedProcessors);
        if (ApiTypeHelper.isDefined(this.architectures)) {
            generator.writeKey("architectures");
            generator.writeStartArray();
            for (ClusterOperatingSystemArchitecture clusterOperatingSystemArchitecture : this.architectures) {
                clusterOperatingSystemArchitecture.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("available_processors");
        generator.write(this.availableProcessors);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        if (ApiTypeHelper.isDefined(this.names)) {
            generator.writeKey("names");
            generator.writeStartArray();
            for (ClusterOperatingSystemName clusterOperatingSystemName : this.names) {
                clusterOperatingSystemName.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.prettyNames)) {
            generator.writeKey("pretty_names");
            generator.writeStartArray();
            for (ClusterOperatingSystemPrettyName clusterOperatingSystemPrettyName : this.prettyNames) {
                clusterOperatingSystemPrettyName.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    public Builder rebuild() {
        return new Builder(this);
    }

    protected static void setupClusterOperatingSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::allocatedProcessors, JsonpDeserializer.integerDeserializer(), "allocated_processors");
        op.add(Builder::architectures, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemArchitecture._DESERIALIZER), "architectures");
        op.add(Builder::availableProcessors, JsonpDeserializer.integerDeserializer(), "available_processors");
        op.add(Builder::mem, OperatingSystemMemoryInfo._DESERIALIZER, "mem");
        op.add(Builder::names, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemName._DESERIALIZER), "names");
        op.add(Builder::prettyNames, JsonpDeserializer.arrayDeserializer(ClusterOperatingSystemPrettyName._DESERIALIZER), "pretty_names");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ClusterOperatingSystem> {
        private Integer allocatedProcessors;
        @Nullable
        private List<ClusterOperatingSystemArchitecture> architectures;
        private Integer availableProcessors;
        private OperatingSystemMemoryInfo mem;
        private List<ClusterOperatingSystemName> names;
        private List<ClusterOperatingSystemPrettyName> prettyNames;

        public Builder() {
        }

        private Builder(ClusterOperatingSystem instance) {
            this.allocatedProcessors = instance.allocatedProcessors;
            this.architectures = instance.architectures;
            this.availableProcessors = instance.availableProcessors;
            this.mem = instance.mem;
            this.names = instance.names;
            this.prettyNames = instance.prettyNames;
        }

        public final Builder allocatedProcessors(int value) {
            this.allocatedProcessors = value;
            return this;
        }

        public final Builder architectures(List<ClusterOperatingSystemArchitecture> list) {
            this.architectures = Builder._listAddAll(this.architectures, list);
            return this;
        }

        public final Builder architectures(ClusterOperatingSystemArchitecture value, ClusterOperatingSystemArchitecture ... values) {
            this.architectures = Builder._listAdd(this.architectures, value, values);
            return this;
        }

        public final Builder architectures(Function<ClusterOperatingSystemArchitecture.Builder, ObjectBuilder<ClusterOperatingSystemArchitecture>> fn) {
            return this.architectures(fn.apply(new ClusterOperatingSystemArchitecture.Builder()).build(), new ClusterOperatingSystemArchitecture[0]);
        }

        public final Builder availableProcessors(int value) {
            this.availableProcessors = value;
            return this;
        }

        public final Builder mem(OperatingSystemMemoryInfo value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<OperatingSystemMemoryInfo.Builder, ObjectBuilder<OperatingSystemMemoryInfo>> fn) {
            return this.mem(fn.apply(new OperatingSystemMemoryInfo.Builder()).build());
        }

        public final Builder names(List<ClusterOperatingSystemName> list) {
            this.names = Builder._listAddAll(this.names, list);
            return this;
        }

        public final Builder names(ClusterOperatingSystemName value, ClusterOperatingSystemName ... values) {
            this.names = Builder._listAdd(this.names, value, values);
            return this;
        }

        public final Builder names(Function<ClusterOperatingSystemName.Builder, ObjectBuilder<ClusterOperatingSystemName>> fn) {
            return this.names(fn.apply(new ClusterOperatingSystemName.Builder()).build(), new ClusterOperatingSystemName[0]);
        }

        public final Builder prettyNames(List<ClusterOperatingSystemPrettyName> list) {
            this.prettyNames = Builder._listAddAll(this.prettyNames, list);
            return this;
        }

        public final Builder prettyNames(ClusterOperatingSystemPrettyName value, ClusterOperatingSystemPrettyName ... values) {
            this.prettyNames = Builder._listAdd(this.prettyNames, value, values);
            return this;
        }

        public final Builder prettyNames(Function<ClusterOperatingSystemPrettyName.Builder, ObjectBuilder<ClusterOperatingSystemPrettyName>> fn) {
            return this.prettyNames(fn.apply(new ClusterOperatingSystemPrettyName.Builder()).build(), new ClusterOperatingSystemPrettyName[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ClusterOperatingSystem build() {
            this._checkSingleUse();
            return new ClusterOperatingSystem(this);
        }
    }
}

